/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.entities.EntityFluorescentTube;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluorescentTube
extends ItemIEBase
implements IConfigurableTool,
IElectricEquipment,
IOBJModelCallback<ItemStack> {
    private static final String LIT_TIME = "litTime";
    private static final String LIT_STRENGTH = "litStrength";
    private static final String[][] special = new String[][]{{"tube"}};

    public ItemFluorescentTube() {
        super("fluorescent_tube", 1, new String[0]);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side == EnumFacing.UP) {
            if (!world.field_72995_K) {
                ItemStack stack = player.func_184586_b(hand);
                Vec3d look = player.func_70040_Z();
                float angle = (float)Math.toDegrees(Math.atan2(look.field_72450_a, look.field_72449_c));
                EntityFluorescentTube tube = new EntityFluorescentTube(world, stack.func_77946_l(), angle);
                tube.func_70107_b((float)pos.func_177958_n() + hitX, (double)pos.func_177956_o() + 1.5, (float)pos.func_177952_p() + hitZ);
                world.func_72838_d((Entity)tube);
                stack.func_77979_a(1);
                if (stack.func_190916_E() > 0) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
                } else {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public static float[] getRGB(ItemStack s) {
        if (ItemNBTHelper.hasKey(s, "rgb")) {
            NBTTagCompound nbt = ItemNBTHelper.getTagCompound(s, "rgb");
            return new float[]{nbt.func_74760_g("r"), nbt.func_74760_g("g"), nbt.func_74760_g("b")};
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public static void setRGB(ItemStack s, float[] rgb) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("r", rgb[0]);
        nbt.func_74776_a("g", rgb[1]);
        nbt.func_74776_a("b", rgb[2]);
        ItemNBTHelper.setTagCompound(s, "rgb", nbt);
    }

    @Override
    public boolean canConfigure(ItemStack stack) {
        return true;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigBoolean[] getBooleanOptions(ItemStack stack) {
        return new IConfigurableTool.ToolConfig.ToolConfigBoolean[0];
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigFloat[] getFloatOptions(ItemStack stack) {
        IConfigurableTool.ToolConfig.ToolConfigFloat[] ret = new IConfigurableTool.ToolConfig.ToolConfigFloat[3];
        float[] rgb = ItemFluorescentTube.getRGB(stack);
        ret[0] = new IConfigurableTool.ToolConfig.ToolConfigFloat("red", 60, 20, rgb[0]);
        ret[1] = new IConfigurableTool.ToolConfig.ToolConfigFloat("green", 60, 40, rgb[1]);
        ret[2] = new IConfigurableTool.ToolConfig.ToolConfigFloat("blue", 60, 60, rgb[2]);
        return ret;
    }

    @Override
    public void applyConfigOption(ItemStack stack, String key, Object value) {
        int id = key.equals("red") ? 0 : (key.equals("green") ? 1 : 2);
        float[] rgb = ItemFluorescentTube.getRGB(stack);
        rgb[id] = ((Float)value).floatValue();
        ItemFluorescentTube.setRGB(stack, rgb);
    }

    @Override
    public String fomatConfigName(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return config.name;
    }

    @Override
    public String fomatConfigDescription(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return config.name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.colour", (Object[])new Object[]{"#" + ItemFluorescentTube.hexColorString(stack)}));
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    @Override
    public boolean hasCustomItemColours() {
        return true;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        if (pass == 0) {
            return ItemFluorescentTube.getRGBInt(stack, 1.0f);
        }
        return super.getColourForIEItem(stack, pass);
    }

    public static int getRGBInt(ItemStack stack, float factor) {
        float[] fRGB = ItemFluorescentTube.getRGB(stack);
        return ((int)(fRGB[0] * 255.0f * factor) << 16) + ((int)(fRGB[1] * 255.0f * factor) << 8) + (int)(fRGB[2] * 255.0f * factor);
    }

    public static String hexColorString(ItemStack stack) {
        String hexCol = Integer.toHexString(ItemFluorescentTube.getRGBInt(stack, 1.0f));
        while (hexCol.length() < 6) {
            hexCol = "0" + hexCol;
        }
        return hexCol;
    }

    public static boolean isLit(ItemStack stack) {
        return ItemNBTHelper.hasKey(stack, LIT_TIME);
    }

    public static void setLit(ItemStack stack, float strength) {
        ItemNBTHelper.setInt(stack, LIT_TIME, 35);
        ItemNBTHelper.setFloat(stack, LIT_STRENGTH, MathHelper.func_76131_a((float)strength, (float)0.0f, (float)1.0f));
    }

    @Override
    public void onStrike(ItemStack s, EntityEquipmentSlot eqSlot, EntityLivingBase p, Map<String, Object> cache, DamageSource dmg, IElectricEquipment.ElectricSource eSource) {
        ItemFluorescentTube.setLit(s, eSource.level);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && ItemFluorescentTube.isLit(stack)) {
            int litTicksRemaining = ItemNBTHelper.getInt(stack, LIT_TIME);
            if (--litTicksRemaining <= 0) {
                ItemNBTHelper.remove(stack, LIT_TIME);
                ItemNBTHelper.remove(stack, LIT_STRENGTH);
            } else {
                ItemNBTHelper.setInt(stack, LIT_TIME, litTicksRemaining);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack) || !Arrays.equals(ItemFluorescentTube.getRGB(oldStack), ItemFluorescentTube.getRGB(newStack));
    }

    @Override
    public String[][] getSpecialGroups(ItemStack stack, ItemCameraTransforms.TransformType transform, EntityLivingBase entity) {
        if (ItemFluorescentTube.isLit(stack)) {
            return special;
        }
        return IOBJModelCallback.EMPTY_STRING_A;
    }

    @Override
    public boolean areGroupsFullbright(ItemStack stack, String[] groups) {
        return groups.length == 1 && "tube".equals(groups[0]) && ItemFluorescentTube.isLit(stack);
    }

    @Override
    public int getRenderColour(ItemStack object, String group) {
        if ("tube".equals(group)) {
            boolean lit = ItemFluorescentTube.isLit(object);
            float min = 0.3f + (lit ? ItemNBTHelper.getFloat(object, LIT_STRENGTH) * 0.68f : 0.0f);
            float mult = min + (lit ? Utils.RAND.nextFloat() * MathHelper.func_76131_a((float)(1.0f - min), (float)0.0f, (float)0.1f) : 0.0f);
            return ItemFluorescentTube.getRGBInt(object, mult) | 0xFF000000;
        }
        return -15658735;
    }
}

