/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.addon.movility;

import com.buuz135.industrial.item.addon.CustomAddon;
import com.buuz135.industrial.item.addon.movility.ITransferAction;
import com.buuz135.industrial.item.addon.movility.ItemStackTransferAddon;
import com.buuz135.industrial.tile.api.IAcceptsTransferAddons;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;
import org.jetbrains.annotations.NotNull;

public abstract class TransferAddon
extends CustomAddon
implements ITransferAction {
    private final ActionMode mode;

    protected TransferAddon(String registryName, ActionMode mode) {
        super(registryName + "_" + mode.name().toLowerCase());
        this.mode = mode;
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b("industrialforegoing." + registryName);
    }

    public EnumFacing getFacingFromMeta(ItemStack stack) {
        return EnumFacing.values()[stack.func_77960_j()];
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        stack.func_77964_b((stack.func_77960_j() + 1) % EnumFacing.values().length);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            ItemStack stack = player.func_184586_b(hand).func_77946_l();
            stack.func_77964_b(facing.func_176745_a());
            player.func_184611_a(hand, stack);
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TextComponentTranslation("text.industrialforegoing.direction", new Object[0]).func_150254_d() + " " + TextFormatting.GRAY + new TextComponentTranslation("text.industrialforegoing." + this.getFacingFromMeta(stack), new Object[0]).func_150254_d());
        tooltip.add(new TextComponentTranslation("text.industrialforegoing.action", new Object[0]).func_150254_d() + " " + TextFormatting.GRAY + new TextComponentTranslation("text.industrialforegoing." + this.mode.name().toLowerCase(), new Object[0]).func_150254_d());
        tooltip.add(new TextComponentTranslation("text.industrialforegoing.tooltip.max_transfer_amount", new Object[0]).func_150260_c() + " " + TextFormatting.GRAY + this.getTransferAmount(stack) * (stack.func_77973_b() instanceof ItemStackTransferAddon ? 1 : 100) + " " + new TextComponentTranslation("text.industrialforegoing.tooltip." + (stack.func_77973_b() instanceof ItemStackTransferAddon ? "items" : "mb"), new Object[0]).func_150260_c() + "/" + new TextComponentTranslation("text.industrialforegoing.tooltip.tick_time", new Object[0]).func_150260_c());
    }

    public boolean func_77616_k(ItemStack stack) {
        return !stack.func_77948_v();
    }

    public int func_77619_b() {
        return 2;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return !stack.func_77948_v() && Enchantment.func_185258_b((Enchantment)enchantment) == 32;
    }

    public int getTransferAmount(ItemStack stack) {
        return (int)Math.pow(2.0, stack.func_77948_v() ? (double)(EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_185262_c((int)32), (ItemStack)stack) + 1) : 1.0);
    }

    public boolean canBeAddedTo(@NotNull SidedTileEntity machine) {
        return machine instanceof IAcceptsTransferAddons && ((IAcceptsTransferAddons)machine).canAcceptAddon(this);
    }

    public float getWorkEnergyMultiplier() {
        return 1.05f;
    }

    public String func_77653_i(ItemStack stack) {
        return new TextComponentTranslation(this.func_77658_a() + ".name", new Object[0]).func_150260_c() + " (" + new TextComponentTranslation("text.industrialforegoing." + this.mode.name().toLowerCase(), new Object[0]).func_150260_c() + "/" + new TextComponentTranslation("text.industrialforegoing." + this.getFacingFromMeta(stack).name().toLowerCase(), new Object[0]).func_150260_c() + ")";
    }

    public void registerRenderer() {
        for (EnumFacing facing : EnumFacing.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)facing.func_176745_a(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString() + "_" + facing.func_176610_l().toLowerCase(), "inventory"));
        }
    }

    public ActionMode getMode() {
        return this.mode;
    }

    public static enum ActionMode {
        PUSH,
        PULL;

    }
}

