/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.google.common.base.Preconditions;
import com.infinityraider.infinitylib.utility.MessageUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public final class LightHelper {
    public static final String[] LIGHT_METHOD_NAMES = new String[]{"getLight(pos)", "getLight(pos, false)", "getLight(pos, true )", "getLightFor(SKY  , pos)", "getLightFor(BLOCK, pos)", "getLightFromNeighbors(pos)", "getLightFromNeighborsFor(SKY  , pos)", "getLightFromNeighborsFor(BLOCK, pos)", "getLightBrightness(pos)"};
    public static final int LIGHT_METHOD_COUNT = LIGHT_METHOD_NAMES.length;

    @Nonnull
    public static byte[] getLightData(@Nonnull World world, @Nonnull BlockPos pos) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)pos);
        byte[] lightData = new byte[LIGHT_METHOD_COUNT];
        lightData[0] = (byte)world.func_175699_k(pos);
        lightData[1] = (byte)world.func_175721_c(pos, false);
        lightData[2] = (byte)world.func_175721_c(pos, true);
        lightData[3] = (byte)world.func_175642_b(EnumSkyBlock.SKY, pos);
        lightData[4] = (byte)world.func_175642_b(EnumSkyBlock.BLOCK, pos);
        lightData[5] = (byte)world.func_175671_l(pos);
        if (world.field_72995_K) {
            lightData[6] = (byte)world.func_175705_a(EnumSkyBlock.SKY, pos);
            lightData[7] = (byte)world.func_175705_a(EnumSkyBlock.BLOCK, pos);
        } else {
            lightData[6] = 0;
            lightData[7] = 0;
        }
        lightData[8] = (byte)world.func_175724_o(pos);
        return lightData;
    }

    public static void messageLightData(@Nullable EntityPlayer player, @Nonnull byte[] clientLightData, @Nonnull byte[] serverLightData) {
        Preconditions.checkNotNull((Object)clientLightData);
        Preconditions.checkNotNull((Object)serverLightData);
        Preconditions.checkArgument((clientLightData.length == LIGHT_METHOD_COUNT ? 1 : 0) != 0);
        Preconditions.checkArgument((serverLightData.length == LIGHT_METHOD_COUNT ? 1 : 0) != 0);
        MessageUtil.messagePlayer((EntityPlayer)player, (String)"`7==================================================`r", (Object[])new Object[0]);
        MessageUtil.messagePlayer((EntityPlayer)player, (String)"       `eLight Level`r", (Object[])new Object[0]);
        MessageUtil.messagePlayer((EntityPlayer)player, (String)"   Client   `7|`r   Server   `7|`r Method Name", (Object[])new Object[0]);
        MessageUtil.messagePlayer((EntityPlayer)player, (String)"`7--------------------------------------------------`r", (Object[])new Object[0]);
        for (int i = 0; i < LIGHT_METHOD_COUNT; ++i) {
            MessageUtil.messagePlayer((EntityPlayer)player, (String)"     {0}     `7|`r     {1}     `7|`r {2}", (Object[])new Object[]{clientLightData[i], serverLightData[i], LIGHT_METHOD_NAMES[i]});
        }
        MessageUtil.messagePlayer((EntityPlayer)player, (String)"`7==================================================`r", (Object[])new Object[0]);
    }
}

