/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.util;

import com.agricraft.agricore.core.AgriCore;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.function.Predicate;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;

public class ResourceHelper {
    private static final Reflections REFLECTIONS = new Reflections(null, new ResourcesScanner());

    public static Set<String> findResources(Predicate<String> nameFilter) {
        return REFLECTIONS.getResources((com.google.common.base.Predicate<String>)((com.google.common.base.Predicate)nameFilter::test));
    }

    public static void copyResource(String from, Path to, boolean overwrite) {
        try {
            if (overwrite || !Files.exists(to, new LinkOption[0])) {
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
                Files.copy(ResourceHelper.getResourceAsStream(from), to, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            AgriCore.getLogger("AgriCraft").error("Unable to copy Jar resource: \"{0}\" to: \"{1}\"!", from, to);
            e.printStackTrace();
        }
    }

    public static InputStream getResourceAsStream(String location) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        return in != null ? in : ResourceHelper.class.getResourceAsStream(location);
    }
}

