/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.trade;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.packet.PacketString;
import me.ichun.mods.hats.common.packet.PacketTradeOffers;
import me.ichun.mods.hats.common.packet.PacketTradeReadyInfo;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class TradeInfo {
    public final EntityPlayer trader1;
    public final EntityPlayer trader2;
    public boolean ready1;
    public boolean ready2;
    public boolean trade1;
    public boolean trade2;
    public TreeMap<String, Integer> trader1Hats = new TreeMap();
    public ArrayList<ItemStack> trader1Items = new ArrayList();
    public TreeMap<String, Integer> trader2Hats = new TreeMap();
    public ArrayList<ItemStack> trader2Items = new ArrayList();
    public boolean terminate;

    public TradeInfo(EntityPlayer t1, EntityPlayer t2) {
        this.trader1 = t1;
        this.trader2 = t2;
    }

    public TradeInfo initialize() {
        Hats.channel.sendTo((AbstractPacket)new PacketString(3, this.trader1.func_70005_c_()), this.trader2);
        Hats.channel.sendTo((AbstractPacket)new PacketString(3, this.trader2.func_70005_c_()), this.trader1);
        return this;
    }

    public void update() {
        boolean sameDimension;
        boolean trader1Alive = this.trader1.func_70089_S();
        boolean trader2Alive = this.trader2.func_70089_S();
        boolean distanceCheck = (double)this.trader1.func_70032_d((Entity)this.trader2) < 16.0;
        boolean clearSpaceCheck = this.trader1.func_70685_l((Entity)this.trader2);
        boolean bl = sameDimension = this.trader1.field_71093_bK == this.trader2.field_71093_bK;
        if (!(trader1Alive && trader2Alive && distanceCheck && clearSpaceCheck && sameDimension)) {
            this.terminate(!trader1Alive || !trader2Alive ? 0 : (!distanceCheck ? 1 : (!clearSpaceCheck ? 2 : 4)), (EntityPlayer)(!trader1Alive ? this.trader1 : (!trader2Alive ? this.trader2 : null)));
        }
    }

    public void terminate(int reason, EntityPlayer terminator) {
        this.terminate = true;
        switch (reason) {
            case 0: {
                this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.terminatePrefix") + " " + I18n.func_74837_a((String)"hats.trade.terminate1", (Object[])new Object[]{I18n.func_74838_a((String)"hats.trade.you")}), terminator);
                this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.terminatePrefix") + " " + I18n.func_74837_a((String)"hats.trade.terminate1", (Object[])new Object[]{terminator.func_70005_c_()}), this.getOtherPlayer(terminator));
                break;
            }
            case 1: {
                this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.terminatePrefix") + " " + I18n.func_74837_a((String)"hats.trade.terminate2", (Object[])new Object[]{this.trader2.func_70005_c_()}), this.trader1);
                this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.terminatePrefix") + " " + I18n.func_74837_a((String)"hats.trade.terminate2", (Object[])new Object[]{this.trader1.func_70005_c_()}), this.trader2);
                break;
            }
            case 2: {
                this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.terminatePrefix") + " " + I18n.func_74838_a((String)"hats.trade.terminate3"), this.trader1, this.trader2);
                break;
            }
            case 3: {
                this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.terminatePrefix") + " " + I18n.func_74837_a((String)"hats.trade.terminate4", (Object[])new Object[]{terminator.func_70005_c_()}), this.getOtherPlayer(terminator));
                break;
            }
            case 4: {
                this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.terminatePrefix") + " " + I18n.func_74837_a((String)"hats.trade.terminate5", (Object[])new Object[]{this.trader2.func_70005_c_()}), this.trader1);
                this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.terminatePrefix") + " " + I18n.func_74837_a((String)"hats.trade.terminate5", (Object[])new Object[]{this.trader1.func_70005_c_()}), this.trader2);
            }
        }
    }

    public void sendTradeMessage(String message, EntityPlayer ... players) {
        for (EntityPlayer player : players) {
            Hats.channel.sendTo((AbstractPacket)new PacketString(2, message), player);
        }
    }

    public void sendReadyInfo() {
        Hats.channel.sendTo((AbstractPacket)new PacketTradeReadyInfo(this.trader1.func_70005_c_(), this.ready1, this.trader2.func_70005_c_(), this.ready2), this.trader1);
        Hats.channel.sendTo((AbstractPacket)new PacketTradeReadyInfo(this.trader1.func_70005_c_(), this.ready1, this.trader2.func_70005_c_(), this.ready2), this.trader2);
    }

    public EntityPlayer getOtherPlayer(EntityPlayer player) {
        return player == this.trader1 ? this.trader2 : this.trader1;
    }

    public boolean isPlayerInTrade(EntityPlayer player) {
        return this.trader1 == player || this.trader2 == player;
    }

    public void receiveTradeInfo(TreeMap<String, Integer> hats, ArrayList<ItemStack> items, EntityPlayerMP player) {
        ArrayList<ItemStack> oldItems;
        TreeMap<String, Integer> oldHats;
        EntityPlayer player2;
        EntityPlayer player1;
        Hats.channel.sendTo((AbstractPacket)new PacketTradeOffers(hats, items), this.getOtherPlayer((EntityPlayer)player));
        TreeMap<String, Integer> newHats = new TreeMap<String, Integer>((SortedMap<String, Integer>)hats);
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>(items);
        if (player == this.trader1) {
            player1 = this.trader1;
            player2 = this.trader2;
            oldHats = new TreeMap<String, Integer>((SortedMap<String, Integer>)this.trader1Hats);
            oldItems = new ArrayList<ItemStack>(this.trader1Items);
            this.trader1Hats = hats;
            this.trader1Items = items;
        } else {
            player1 = this.trader2;
            player2 = this.trader1;
            oldHats = new TreeMap<String, Integer>((SortedMap<String, Integer>)this.trader2Hats);
            oldItems = new ArrayList<ItemStack>(this.trader2Items);
            this.trader2Hats = hats;
            this.trader2Items = items;
        }
        Iterator<Map.Entry<String, Integer>> ite = newHats.entrySet().iterator();
        block0: while (ite.hasNext()) {
            Map.Entry<String, Integer> e = ite.next();
            for (Map.Entry<String, Integer> e1 : oldHats.entrySet()) {
                if (!((String)e.getKey()).equals(e1.getKey())) continue;
                e.setValue((Integer)e.getValue() - e1.getValue());
                if ((Integer)e.getValue() > 0) continue;
                ite.remove();
                continue block0;
            }
        }
        block2: for (ItemStack is : oldItems) {
            for (int i = newItems.size() - 1; i >= 0; --i) {
                if (!ItemStack.func_77989_b((ItemStack)newItems.get(i), (ItemStack)is)) continue;
                newItems.remove(i);
                continue block2;
            }
        }
        Iterator<Map.Entry<String, Integer>> ite1 = oldHats.entrySet().iterator();
        block4: while (ite1.hasNext()) {
            Map.Entry<String, Integer> e = ite1.next();
            for (Map.Entry<String, Integer> e1 : hats.entrySet()) {
                if (!((String)e.getKey()).equals(e1.getKey())) continue;
                e.setValue((Integer)e.getValue() - e1.getValue());
                if ((Integer)e.getValue() > 0) continue;
                ite1.remove();
                continue block4;
            }
        }
        block6: for (ItemStack is : items) {
            for (int i = oldItems.size() - 1; i >= 0; --i) {
                if (!ItemStack.func_77989_b((ItemStack)oldItems.get(i), (ItemStack)is)) continue;
                oldItems.remove(i);
                continue block6;
            }
        }
        for (int i = oldItems.size() - 1; i >= 0; --i) {
            for (int j = newItems.size() - 1; j >= 0; --j) {
                ItemStack is;
                ItemStack newStack;
                ItemStack oldStack = oldItems.get(i);
                if (!oldStack.func_77969_a(newStack = newItems.get(j)) || !ItemStack.func_77970_a((ItemStack)oldStack, (ItemStack)newStack)) continue;
                int difference = oldStack.func_190916_E() - newStack.func_190916_E();
                oldItems.remove(i);
                newItems.remove(j);
                if (difference < 0) {
                    is = newStack.func_77946_l();
                    is.func_190920_e(Math.abs(difference));
                    newItems.add(j, is);
                    continue;
                }
                is = oldStack.func_77946_l();
                is.func_190920_e(Math.abs(difference));
                oldItems.add(i, is);
            }
        }
        for (Map.Entry<String, Integer> e : oldHats.entrySet()) {
            this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.you") + " " + I18n.func_74838_a((String)"hats.trade.removed") + " " + TextFormatting.WHITE.toString() + e.getKey(), player1);
            this.sendTradeMessage(player1.func_70005_c_() + " " + I18n.func_74838_a((String)"hats.trade.removed") + " " + TextFormatting.WHITE.toString() + e.getKey(), player2);
        }
        for (ItemStack is : oldItems) {
            this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.you") + " " + I18n.func_74838_a((String)"hats.trade.removed") + " " + TextFormatting.WHITE.toString() + is.func_190916_E() + " " + is.func_82833_r(), player1);
            this.sendTradeMessage(player1.func_70005_c_() + " " + I18n.func_74838_a((String)"hats.trade.removed") + " " + TextFormatting.WHITE.toString() + is.func_190916_E() + " " + is.func_82833_r(), player2);
        }
        for (Map.Entry<String, Integer> e : newHats.entrySet()) {
            this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.you") + " " + I18n.func_74838_a((String)"hats.trade.added") + " " + TextFormatting.WHITE.toString() + e.getKey(), player1);
            this.sendTradeMessage(player1.func_70005_c_() + " " + I18n.func_74838_a((String)"hats.trade.added") + " " + TextFormatting.WHITE.toString() + e.getKey(), player2);
        }
        for (ItemStack is : newItems) {
            this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.you") + " " + I18n.func_74838_a((String)"hats.trade.added") + " " + TextFormatting.WHITE.toString() + is.func_190916_E() + " " + is.func_82833_r(), player1);
            this.sendTradeMessage(player1.func_70005_c_() + " " + I18n.func_74838_a((String)"hats.trade.added") + " " + TextFormatting.WHITE.toString() + is.func_190916_E() + " " + is.func_82833_r(), player2);
        }
        this.resetReady();
    }

    public void resetReady() {
        this.toggleReadyTrader1(false);
        this.toggleReadyTrader2(false);
    }

    public void toggleReadyTrader1(boolean shouldReady) {
        if (!shouldReady && this.ready1) {
            this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.notReady"), this.trader1);
            this.sendTradeMessage(I18n.func_74837_a((String)"hats.trade.notReadyThem", (Object[])new Object[]{this.trader1.func_70005_c_()}), this.trader2);
            this.ready1 = false;
            this.trade2 = false;
            this.trade1 = false;
            this.sendReadyInfo();
        } else if (shouldReady && !this.ready1) {
            this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.ready"), this.trader1);
            this.sendTradeMessage(I18n.func_74837_a((String)"hats.trade.readyThem", (Object[])new Object[]{this.trader1.func_70005_c_()}), this.trader2);
            this.ready1 = true;
            this.sendReadyInfo();
        }
    }

    public void toggleReadyTrader2(boolean shouldReady) {
        if (!shouldReady && this.ready2) {
            this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.notReady"), this.trader2);
            this.sendTradeMessage(I18n.func_74837_a((String)"hats.trade.notReadyThem", (Object[])new Object[]{this.trader2.func_70005_c_()}), this.trader1);
            this.ready2 = false;
            this.trade2 = false;
            this.trade1 = false;
            this.sendReadyInfo();
        } else if (shouldReady && !this.ready2) {
            this.sendTradeMessage(I18n.func_74838_a((String)"hats.trade.ready"), this.trader2);
            this.sendTradeMessage(I18n.func_74837_a((String)"hats.trade.readyThem", (Object[])new Object[]{this.trader2.func_70005_c_()}), this.trader1);
            this.ready2 = true;
            this.sendReadyInfo();
        }
    }
}

