/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.thread;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.DocumentBuilderFactory;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.core.HatHandler;
import me.ichun.mods.ichunutil.common.module.tabula.formats.ImportList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThreadHatsReader
extends Thread {
    public final File hatsFolder;
    public final boolean shouldDownload;
    public final boolean loadGuiOnEnd;

    public ThreadHatsReader(File hatsFolder, boolean shouldDownload, boolean loadGuiOnEnd) {
        this.hatsFolder = hatsFolder;
        this.shouldDownload = shouldDownload;
        this.loadGuiOnEnd = loadGuiOnEnd;
        this.setName("Hats Download/Read Hats Thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        File[] files;
        File[] favs;
        if (this.shouldDownload) {
            int hatDownloaded = 0;
            try {
                URL var1 = new URL("https://dist.creeper.host/ichun/static/hatstabula.xml");
                DocumentBuilderFactory var2 = DocumentBuilderFactory.newInstance();
                File[] var3 = var2.newDocumentBuilder();
                HttpsURLConnection con = (HttpsURLConnection)var1.openConnection();
                con.setConnectTimeout(60000);
                con.setReadTimeout(60000);
                Document var4 = var3.parse(con.getInputStream());
                NodeList var5 = var4.getElementsByTagName("File");
                for (int var6 = 0; var6 < 2; ++var6) {
                    for (int var7 = 0; var7 < var5.getLength(); ++var7) {
                        Element var9;
                        String var10;
                        Node var8 = var5.item(var7);
                        if (var8.getNodeType() != 1 || (var10 = (var9 = (Element)var8).getElementsByTagName("Path").item(0).getChildNodes().item(0).getNodeValue()).endsWith(".md5")) continue;
                        long var11 = Long.parseLong(var9.getElementsByTagName("Size").item(0).getChildNodes().item(0).getNodeValue());
                        String url = var9.getElementsByTagName("URL").item(0).getChildNodes().item(0).getNodeValue();
                        if (var11 <= 0L || !this.downloadResource(new URL(url = url.replaceAll(" ", "%20").replaceAll("http://cdn.redstone.tech", "https://dist.creeper.host")), new File(this.hatsFolder, var10), var11)) continue;
                        ++hatDownloaded;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (hatDownloaded != 0) {
                Hats.console("Downloaded " + hatDownloaded + " hats from Creeperhost Hat Repository");
            }
        }
        int hatCount = 0;
        HatHandler.reloadingHats = true;
        Hats.proxy.clearAllHats();
        File fav = new File(this.hatsFolder, "/Favourites");
        if (!fav.exists()) {
            fav.mkdirs();
        }
        for (File file : favs = fav.listFiles()) {
            File hat;
            if (file.isDirectory() || !ImportList.isFileSupported((File)file) || (hat = new File(this.hatsFolder, file.getName())).exists()) continue;
            FileInputStream inStream = null;
            FileOutputStream outStream = null;
            try {
                int length;
                inStream = new FileInputStream(file);
                outStream = new FileOutputStream(hat);
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                    ((OutputStream)outStream).write(buffer, 0, length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (outStream == null) continue;
                ((OutputStream)outStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (File file : files = this.hatsFolder.listFiles()) {
            if (file.isDirectory() || !HatHandler.readHatFromFile(file)) continue;
            ++hatCount;
        }
        int contribHats = 0;
        for (File file : files) {
            if (!file.isDirectory() || file.getName().equalsIgnoreCase("Disabled")) continue;
            if (file.getName().equalsIgnoreCase("Contributors")) {
                hatCount += (contribHats += HatHandler.loadCategory(file));
                continue;
            }
            hatCount += HatHandler.loadCategory(file);
        }
        Hats.console((this.loadGuiOnEnd ? "Reloaded " : "Loaded ") + Integer.toString(hatCount) + (hatCount == 1 ? " hat" : " hats. " + contribHats + " are contributor hats."));
        HatHandler.reloadingHats = false;
        if (this.loadGuiOnEnd) {
            HatHandler.reloadAndOpenGui();
        }
    }

    public boolean downloadResource(URL par1URL, File par2File, long size) throws IOException {
        if (par2File.exists()) {
            if (par2File.length() == size || HatHandler.isHatReadable(par2File)) {
                return false;
            }
        } else if (!par2File.getParentFile().exists()) {
            par2File.getParentFile().mkdirs();
        }
        byte[] var5 = new byte[4096];
        HttpsURLConnection con = (HttpsURLConnection)par1URL.openConnection();
        con.setConnectTimeout(15000);
        con.setReadTimeout(15000);
        DataInputStream var6 = new DataInputStream(con.getInputStream());
        DataOutputStream var7 = new DataOutputStream(new FileOutputStream(par2File));
        boolean var8 = false;
        while (true) {
            int var9;
            if ((var9 = var6.read(var5)) < 0) {
                var6.close();
                var7.close();
                return true;
            }
            var7.write(var5, 0, var9);
        }
    }
}

