/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.utils;

import baubles.api.cap.IBaublesItemHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class TinySlot {
    private final ItemStack stack;

    public TinySlot(@Nonnull ItemStack stack) {
        Objects.requireNonNull(stack, "stack cannot be null");
        this.stack = stack;
    }

    @Nonnull
    public ItemStack getStack() {
        return this.stack;
    }

    public void markDirty() {
    }

    public static class BaublesSlot
    extends TinySlot {
        private final IBaublesItemHandler handler;
        private final int slot;

        public BaublesSlot(@Nonnull ItemStack stack, @Nonnull IBaublesItemHandler handler, int slot) {
            super(stack);
            this.handler = handler;
            this.slot = slot;
        }

        @Override
        public void markDirty() {
            this.handler.setChanged(this.slot, true);
        }
    }

    public static class InventorySlot
    extends TinySlot {
        private final IInventory inventory;

        public InventorySlot(@Nonnull ItemStack stack, @Nonnull IInventory inventory) {
            super(stack);
            this.inventory = inventory;
        }

        @Override
        public void markDirty() {
            this.inventory.func_70296_d();
        }
    }
}

