/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;

public final class IngredientBrew
extends Ingredient {
    private final Potion potion;
    private final ItemStack[] basicStacks;
    private IntList packed;

    private IngredientBrew(Potion potion, PotionType potionType) {
        super(new ItemStack[0]);
        this.potion = potion;
        this.basicStacks = new ItemStack[3];
        this.basicStacks[0] = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potionType);
        this.basicStacks[1] = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potionType);
        this.basicStacks[2] = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)potionType);
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        return this.basicStacks;
    }

    @Nonnull
    public IntList func_194139_b() {
        if (this.packed == null) {
            this.packed = new IntArrayList();
            for (ItemStack stack : this.basicStacks) {
                this.packed.add(RecipeItemHelper.func_194113_b((ItemStack)stack));
            }
            this.packed.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.packed;
    }

    public boolean apply(@Nullable ItemStack target) {
        if (target == null || target.func_190926_b()) {
            return false;
        }
        for (PotionEffect effect : PotionUtils.func_185189_a((ItemStack)target)) {
            if (effect.func_188419_a() != this.potion) continue;
            return true;
        }
        return false;
    }

    protected void invalidate() {
        this.packed = null;
    }

    public boolean isSimple() {
        return false;
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            ResourceLocation effect = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"effect"));
            if (!Potion.field_188414_b.func_148741_d((Object)effect)) {
                throw new JsonSyntaxException("Unknown effect '" + effect + "'");
            }
            ResourceLocation potion = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"potion"));
            if (!PotionType.field_185176_a.func_148741_d((Object)potion)) {
                throw new JsonSyntaxException("Unknown potion '" + potion + "'");
            }
            return new IngredientBrew((Potion)Potion.field_188414_b.func_82594_a((Object)effect), (PotionType)PotionType.field_185176_a.func_82594_a((Object)potion));
        }
    }
}

