/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.method;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.integration.vanilla.meta.VanillaMeta;

public final class MethodsVanillaTileEntities {
    private MethodsVanillaTileEntities() {
    }

    @PlethoraMethod(doc="function():int -- Number of ticks of fuel left", worldThread=false)
    public static int getRemainingBurnTime(@FromTarget TileEntityFurnace furnace) {
        return furnace.func_174887_a_(0);
    }

    @PlethoraMethod(doc="function():int -- Number of ticks of burning the current fuel provides", worldThread=false)
    public static int getBurnTime(@FromTarget TileEntityFurnace furnace) {
        return furnace.func_174887_a_(1);
    }

    @PlethoraMethod(doc="function():int -- Number of ticks the current item has cooked for", worldThread=false)
    public static int getCookTime(@FromTarget TileEntityFurnace furnace) {
        return furnace.func_174887_a_(2);
    }

    @PlethoraMethod(doc="function():int -- Number of ticks the current potion has brewed for", worldThread=false)
    public static int getBrewTime(@FromTarget TileEntityBrewingStand brewing) {
        return brewing.func_174887_a_(0);
    }

    @PlethoraMethod(doc="function():table -- Each line of text on this sign")
    public static Map<Integer, String> getSignText(@FromTarget TileEntitySign sign) {
        return VanillaMeta.getSignLines(sign);
    }

    @PlethoraMethod(doc="function(lines...:string) -- Set the lines of text on this sign")
    public static void setSignText(@FromTarget TileEntitySign sign, Object[] args) throws LuaException {
        ITextComponent[] lines = new ITextComponent[4];
        for (int i = 0; i < lines.length; ++i) {
            String arg = ArgumentHelper.optString((Object[])args, (int)i, (String)"");
            if (arg.length() > 64) {
                throw new LuaException("Expected length <= 64 for argument (" + (i + 1) + "), got " + arg.length());
            }
            lines[i] = new TextComponentString(arg);
        }
        System.arraycopy(lines, 0, sign.field_145915_a, 0, lines.length);
        sign.func_70296_d();
        World world = sign.func_145831_w();
        BlockPos pos = sign.func_174877_v();
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 3);
    }
}

