/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.method;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.method.IUnbakedContext;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.method.wrapper.FromSubtarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.SubtargetedModuleMethod;
import org.squiddev.plethora.gameplay.ConfigGameplay;
import org.squiddev.plethora.gameplay.modules.ItemModule;
import org.squiddev.plethora.gameplay.modules.PlethoraModules;
import org.squiddev.plethora.integration.vanilla.DisableAI;

@Injects
public final class MethodsKinetic {
    public static final SubtargetedModuleMethod<Entity> LAUNCH = SubtargetedModuleMethod.of(MethodsKinetic.class.getName() + "#launch", "launch", PlethoraModules.KINETIC_M, Entity.class, "function(yaw:number, pitch:number, power:number) -- Launch the entity in a set direction", MethodsKinetic::launch);
    public static final SubtargetedModuleMethod<EntityLiving> WALK = SubtargetedModuleMethod.of(MethodsKinetic.class.getName() + "#walk", "walk", PlethoraModules.KINETIC_M, EntityLiving.class, "function(x:number, y:number, z:number):boolean, string|nil -- Walk to a coordinate", MethodsKinetic::walk);

    private MethodsKinetic() {
    }

    private static MethodResult launch(@Nonnull IUnbakedContext<IModuleContainer> context, @Nonnull Object[] args) throws LuaException {
        float yaw = (float)ArgumentHelper.getReal((Object[])args, (int)0) % 360.0f;
        float pitch = (float)ArgumentHelper.getReal((Object[])args, (int)1) % 360.0f;
        float power = (float)ArgumentHelper.getReal((Object[])args, (int)2);
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(power, 0.0, (double)ConfigGameplay.Kinetic.launchMax, "Power out of range (%s).");
        return context.getCostHandler().await((double)(power * (float)ConfigGameplay.Kinetic.launchCost), MethodResult.nextTick(() -> {
            Entity entity = context.bake().getContext("origin", Entity.class);
            ItemModule.launch(entity, yaw, pitch, power);
            return MethodResult.empty();
        }));
    }

    @PlethoraMethod(module={"plethora:kinetic"}, doc="-- Disable the AI of this entity. Their neural pathways will be inhibited preventing them thinking for themselves")
    public static void disableAI(@FromSubtarget(value={"origin"}) EntityLiving entity) throws LuaException {
        DisableAI.IDisableAIHandler disable = (DisableAI.IDisableAIHandler)entity.getCapability(DisableAI.DISABLE_AI_CAPABILITY, null);
        if (disable == null) {
            throw new LuaException("Cannot disable AI");
        }
        disable.setDisabled(true);
    }

    @PlethoraMethod(module={"plethora:kinetic"}, doc="-- Enable the AI of this entity.")
    public static void enableAI(@FromSubtarget(value={"origin"}) EntityLiving entity) throws LuaException {
        DisableAI.IDisableAIHandler disable = (DisableAI.IDisableAIHandler)entity.getCapability(DisableAI.DISABLE_AI_CAPABILITY, null);
        if (disable == null) {
            throw new LuaException("Cannot enable AI");
        }
        disable.setDisabled(false);
    }

    @Nonnull
    private static MethodResult walk(@Nonnull IUnbakedContext<IModuleContainer> context, @Nonnull Object[] args) throws LuaException {
        double x = ArgumentHelper.getReal((Object[])args, (int)0);
        double y = ArgumentHelper.getReal((Object[])args, (int)1);
        double z = ArgumentHelper.getReal((Object[])args, (int)2);
        double speed = ArgumentHelper.optNumber((Object[])args, (int)3, (double)1.0);
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(x, (double)(-ConfigGameplay.Kinetic.walkRange), (double)ConfigGameplay.Kinetic.walkRange, "X coordinate out of bounds (%s)");
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(y, (double)(-ConfigGameplay.Kinetic.walkRange), (double)ConfigGameplay.Kinetic.walkRange, "Y coordinate out of bounds (%s)");
        org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(z, (double)(-ConfigGameplay.Kinetic.walkRange), (double)ConfigGameplay.Kinetic.walkRange, "Z coordinate out of bounds (%s)");
        if (!Double.isNaN(speed)) {
            org.squiddev.plethora.api.method.ArgumentHelper.assertBetween(speed, 1.0, (double)ConfigGameplay.Kinetic.walkSpeed, "Speed coordinate out of bounds (%s)");
        }
        double cost = Math.sqrt(x * x + y * y + z * z) * (double)ConfigGameplay.Kinetic.walkCost;
        return context.getCostHandler().await(cost, MethodResult.nextTick(() -> {
            EntityLiving living = context.bake().getContext("origin", EntityLiving.class);
            PathNavigate navigator = living.func_70661_as();
            Path path = navigator.func_75488_a(x + living.field_70165_t, y + living.field_70163_u, z + living.field_70161_v);
            if (path == null || path.func_75874_d() == 0) {
                return MethodResult.failure("No path exists");
            }
            if (!context.getCostHandler().consume((double)(path.func_75874_d() * 5) * speed)) {
                return MethodResult.failure("Insufficient energy");
            }
            return MethodResult.result((Object)living.func_70661_as().func_75484_a(path, speed));
        }));
    }

    @PlethoraMethod(module={"plethora:kinetic"}, doc="-- Whether the entity is currently walking somewhere.")
    public static boolean isWalking(@FromSubtarget(value={"origin"}) EntityLiving target) {
        return !target.func_70661_as().func_75500_f();
    }
}

