/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.method;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.method.BasicMethod;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.IUnbakedContext;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.reference.BlockReference;

@Injects
public final class MethodFluidHandler
extends BasicMethod<ICapabilityProvider> {
    public MethodFluidHandler() {
        super("getTanks", "function([side:string]):table -- Get a list of all tanks on this side");
    }

    @Override
    public boolean canApply(@Nonnull IPartialContext<ICapabilityProvider> context) {
        if (!super.canApply(context)) {
            return false;
        }
        ICapabilityProvider target = context.getTarget();
        if (target.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!target.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public MethodResult apply(@Nonnull IUnbakedContext<ICapabilityProvider> context, @Nonnull Object[] args) throws LuaException {
        EnumFacing facing;
        String side = ArgumentHelper.optString((Object[])args, (int)0, null);
        if (side != null) {
            facing = EnumFacing.func_176739_a((String)(side = side.toLowerCase()));
            if (facing == null) {
                throw new LuaException("Unknown side '" + side + "'");
            }
        } else {
            facing = null;
        }
        return MethodResult.nextTick(() -> {
            BlockReference location;
            IContext baked = context.bake();
            ICapabilityProvider provider = (ICapabilityProvider)baked.getTarget();
            IFluidTankProperties[] tanks = MethodFluidHandler.getTanks(provider, facing);
            if (tanks == null && facing == null && (location = baked.getContext("target", BlockReference.class)) != null && location.getSide() != null) {
                tanks = MethodFluidHandler.getTanks(provider, location.getSide());
            }
            if (tanks == null) {
                return MethodResult.result(Collections.emptyMap());
            }
            HashMap out = new HashMap(tanks.length);
            for (int i = 0; i < tanks.length; ++i) {
                out.put(i + 1, baked.makePartialChild(tanks[i]).getMeta());
            }
            return MethodResult.result(out);
        });
    }

    private static IFluidTankProperties[] getTanks(ICapabilityProvider provider, EnumFacing side) {
        IFluidHandler handler = (IFluidHandler)provider.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        if (handler == null) {
            return null;
        }
        IFluidTankProperties[] tanks = handler.getTankProperties();
        return tanks == null || tanks.length == 0 ? null : tanks;
    }
}

