/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.meta;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.meta.ItemStackMetaProvider;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.integration.ItemEntityStorageMetaProvider;
import org.squiddev.plethora.utils.WorldDummy;

@Injects
public final class MetaItems {
    public static final IMetaProvider<ItemStack> ITEM_FOOD = new ItemStackMetaProvider<ItemFood>(ItemFood.class, "Provides the hunger and saturation this foodstuff restores."){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull ItemStack stack, @Nonnull ItemFood food) {
            HashMap<String, Number> data = new HashMap<String, Number>(2);
            data.put("heal", food.func_150905_g(stack));
            data.put("saturation", Float.valueOf(food.func_150906_h(stack)));
            return data;
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            return new ItemStack(Items.field_151168_bH);
        }
    };
    public static final IMetaProvider<ItemStack> ITEM_POTION = new ItemStackMetaProvider<ItemPotion>(ItemPotion.class, "Provides the potion type and effects of this item."){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull ItemStack stack, @Nonnull ItemPotion itemPotion) {
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            if (itemPotion instanceof ItemSplashPotion) {
                data.put("splash", true);
                data.put("potionType", "splash");
            } else if (itemPotion instanceof ItemLingeringPotion) {
                data.put("potionType", "lingering");
            } else {
                data.put("potionType", "normal");
            }
            PotionType potionType = PotionUtils.func_185191_c((ItemStack)stack);
            data.put("potion", potionType.getRegistryName().toString());
            List effects = PotionUtils.func_185189_a((ItemStack)stack);
            if (!effects.isEmpty()) {
                LuaList effectsInfo = new LuaList(effects.size());
                for (PotionEffect effect : effects) {
                    HashMap<String, Object> entry = new HashMap<String, Object>();
                    entry.put("duration", effect.func_76459_b() / 20);
                    entry.put("amplifier", effect.func_76458_c());
                    Potion potion = effect.func_188419_a();
                    entry.put("name", potion.func_76393_a());
                    entry.put("instant", potion.func_76403_b());
                    entry.put("color", potion.func_76401_j());
                    effectsInfo.add(entry);
                }
                data.put("effects", effectsInfo.asMap());
            }
            return data;
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            return PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185243_o);
        }
    };
    public static final IMetaProvider<ItemStack> ITEM_SPAWN_EGG = new ItemEntityStorageMetaProvider<ItemMonsterPlacer>("storedEntity", ItemMonsterPlacer.class, "Provides information about items captured within spawn eggs."){

        @Override
        @Nullable
        protected Entity spawn(@Nonnull ItemStack stack, @Nonnull ItemMonsterPlacer item, @Nonnull IWorldLocation location) {
            ResourceLocation id = ItemMonsterPlacer.func_190908_h((ItemStack)stack);
            if (id == null) {
                return null;
            }
            Entity entity = EntityList.func_188429_b((ResourceLocation)id, (World)WorldDummy.INSTANCE);
            if (entity == null) {
                return null;
            }
            if (stack.func_82837_s()) {
                entity.func_96094_a(stack.func_82833_r());
            }
            NBTTagCompound stackTag = stack.func_77978_p();
            if (!entity.func_184213_bq() && stackTag != null && stackTag.func_150297_b("EntityTag", 10)) {
                NBTTagCompound entityData = entity.func_189511_e(new NBTTagCompound());
                UUID uuid = entity.func_110124_au();
                entityData.func_179237_a(stackTag.func_74775_l("EntityTag"));
                entity.func_184221_a(uuid);
                entity.func_70020_e(entityData);
            }
            return entity;
        }

        @Override
        @Nonnull
        protected Map<String, ?> getBasicDetails(@Nonnull ItemStack stack, @Nonnull ItemMonsterPlacer item) {
            ResourceLocation id = ItemMonsterPlacer.func_190908_h((ItemStack)stack);
            return id != null ? 3.getBasicDetails(id, stack.func_82837_s() ? stack.func_82833_r() : null) : Collections.emptyMap();
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            ItemStack stack = new ItemStack(Items.field_151063_bx, 1);
            Iterator eggs = EntityList.field_75627_a.values().iterator();
            if (eggs.hasNext()) {
                ItemMonsterPlacer.func_185078_a((ItemStack)stack, (ResourceLocation)((EntityList.EntityEggInfo)eggs.next()).field_75613_a);
            }
            return stack;
        }
    };
    public static final IMetaProvider<ItemStack> ITEM_TOOL_CLASS = new BasicMetaProvider<ItemStack>("Provides the tool classes an item may have."){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull ItemStack stack) {
            Item item = stack.func_77973_b();
            Set toolClasses = item.getToolClasses(stack);
            if (toolClasses.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, Integer> types = new HashMap<String, Integer>();
            for (String tool : item.getToolClasses(stack)) {
                types.put(tool, item.getHarvestLevel(stack, tool, null, null));
            }
            return Collections.singletonMap("toolClass", types);
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            return new ItemStack(Items.field_151046_w);
        }
    };
}

