/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.roost;

import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import com.timwoodcreates.roost.tileentity.TileEntityBreeder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import org.squiddev.plethora.api.method.ContextHelpers;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;

public final class MethodsRoost {
    private static final String MINECRAFT_CHICKEN = "minecraft:chicken";

    private MethodsRoost() {
    }

    @PlethoraMethod(modId="roost", doc="-- Get a list of all chickens species, with the species name as the index")
    public static Map<String, Object> getSpeciesList(@Nonnull IContext<TileEntityBreeder> context) {
        Map<String, Object> vanillaChicken = MethodsRoost.getVanillaChicken(context);
        if (Loader.isModLoaded((String)"chickens")) {
            Map<String, Object> species = ChickensRegistry.getItems().stream().collect(Collectors.toMap(item -> item.getRegistryName().toString(), item -> context.makePartialChild(item).getMeta(), (a, b) -> b));
            species.put(MINECRAFT_CHICKEN, vanillaChicken);
            return species;
        }
        return Collections.singletonMap(MINECRAFT_CHICKEN, vanillaChicken);
    }

    @PlethoraMethod(modId="roost", doc="-- Get a single chicken species")
    public static Map<String, ?> getSpecies(@Nonnull IContext<TileEntityBreeder> context, String name) {
        if (MINECRAFT_CHICKEN.equals(name)) {
            return MethodsRoost.getVanillaChicken(context);
        }
        if (Loader.isModLoaded((String)"chickens")) {
            ChickensRegistryItem species = ChickensRegistry.getByRegistryName((String)name);
            return species != null ? context.makePartialChild(species).getMeta() : Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    private static Map<String, Object> getVanillaChicken(@Nonnull IPartialContext<?> context) {
        HashMap<String, Object> out = new HashMap<String, Object>(6);
        out.put("type", MINECRAFT_CHICKEN);
        out.put("tier", 0);
        out.put("layItem", ContextHelpers.wrapStack(context, new ItemStack(Items.field_151008_G)));
        out.put("dropItem", null);
        out.put("parent1", null);
        out.put("parent2", null);
        return out;
    }
}

