/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.hatchery;

import com.gendeathrow.hatchery.block.nest.EggNestTileEntity;
import com.gendeathrow.hatchery.block.nestpen.NestPenTileEntity;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.entities.EntityRooster;
import com.gendeathrow.hatchery.item.AnimalNet;
import com.gendeathrow.hatchery.item.HatcheryEgg;
import com.gendeathrow.hatchery.util.ItemStackEntityNBTHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.integration.ItemEntityStorageMetaProvider;
import org.squiddev.plethora.utils.EntityPlayerDummy;
import org.squiddev.plethora.utils.WorldDummy;

@Injects(value="hatchery")
public final class IntegrationHatchery {
    public static final IMetaProvider<ItemStack> META_ANIMAL_NET = new ItemEntityStorageMetaProvider<AnimalNet>("capturedEntity", AnimalNet.class, "Provides the entity captured inside this Animal Net."){

        @Override
        @Nullable
        protected Entity spawn(@Nonnull ItemStack stack, @Nonnull AnimalNet item, @Nonnull IWorldLocation location) {
            if (!AnimalNet.hasCapturedAnimal((ItemStack)stack)) {
                return null;
            }
            NBTTagCompound entityData = AnimalNet.getCapturedAnimalNBT((ItemStack)stack);
            if (!entityData.func_150297_b("id", 8)) {
                return null;
            }
            return EntityList.func_75615_a((NBTTagCompound)entityData, (World)location.getWorld());
        }

        @Override
        @Nonnull
        protected Map<String, ?> getBasicDetails(@Nonnull ItemStack stack, @Nonnull AnimalNet item) {
            if (!AnimalNet.hasCapturedAnimal((ItemStack)stack)) {
                return Collections.emptyMap();
            }
            return 1.getBasicDetails(AnimalNet.getCapturedAnimalNBT((ItemStack)stack));
        }

        @Override
        @Nullable
        public ItemStack getExample() {
            return AnimalNet.addEntitytoNet((EntityPlayer)new EntityPlayerDummy(WorldDummy.INSTANCE), (ItemStack)new ItemStack(ModItems.animalNet), (Entity)new EntityCow((World)WorldDummy.INSTANCE));
        }
    };
    public static final IMetaProvider<ItemStack> META_HATCHERY_EGG = new ItemEntityStorageMetaProvider<HatcheryEgg>("storedEntity", HatcheryEgg.class, "Provides the entity that may spawn from this Egg"){

        @Override
        @Nullable
        protected Entity spawn(@Nonnull ItemStack stack, @Nonnull HatcheryEgg item, @Nonnull IWorldLocation location) {
            NBTTagCompound entityData = ItemStackEntityNBTHelper.getEntityTagFromStack((ItemStack)stack);
            if (entityData == null || !entityData.func_150297_b("id", 8)) {
                return null;
            }
            Entity entity = EntityList.func_75615_a((NBTTagCompound)entityData, (World)location.getWorld());
            if (entity == null) {
                entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(entityData.func_74779_i("id")), (World)location.getWorld());
            }
            return entity;
        }

        @Override
        @Nonnull
        protected Map<String, ?> getBasicDetails(@Nonnull ItemStack stack, @Nonnull HatcheryEgg item) {
            return 2.getBasicDetails(ItemStackEntityNBTHelper.getEntityTagFromStack((ItemStack)stack));
        }

        @Override
        @Nonnull
        public ItemStack getExample() {
            return HatcheryEgg.createEggFromEntity((World)WorldDummy.INSTANCE, (EntityAgeable)new EntityChicken((World)WorldDummy.INSTANCE));
        }
    };
    public static final IMetaProvider<EntityRooster> META_ROOSTER = new BasicMetaProvider<EntityRooster>(){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull EntityRooster target) {
            return Collections.singletonMap("seeds", target.getSeeds());
        }

        @Override
        @Nonnull
        public EntityRooster getExample() {
            return new EntityRooster((World)WorldDummy.INSTANCE);
        }
    };
    public static final IMetaProvider<NestPenTileEntity> META_NEST_PEN = new BaseMetaProvider<NestPenTileEntity>(){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<NestPenTileEntity> context) {
            NestPenTileEntity target = context.getTarget();
            EntityAgeable storedEntity = target.storedEntity();
            return storedEntity != null ? Collections.singletonMap("storedEntity", context.makePartialChild(storedEntity).getMeta()) : Collections.emptyMap();
        }

        @Override
        @Nullable
        public NestPenTileEntity getExample() {
            WorldDummy.INSTANCE.func_175656_a(BlockPos.field_177992_a, ModBlocks.pen.func_176223_P());
            TileEntity te = WorldDummy.INSTANCE.func_175625_s(BlockPos.field_177992_a);
            if (!(te instanceof NestPenTileEntity)) {
                return null;
            }
            NestPenTileEntity pen = (NestPenTileEntity)te;
            pen.trySetEntity((Entity)new EntityChicken((World)WorldDummy.INSTANCE));
            return pen;
        }
    };
    public static final IMetaProvider<EggNestTileEntity> META_EGG_NEST = new BaseMetaProvider<EggNestTileEntity>(){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<EggNestTileEntity> context) {
            HashMap<String, Object> out = new HashMap<String, Object>(2);
            EggNestTileEntity target = context.getTarget();
            ItemStack egg = target.getEgg();
            if (egg != null) {
                out.put("egg", context.makePartialChild(egg).getMeta());
                out.put("hatchPercent", Float.valueOf(target.getPercentage()));
            }
            return out;
        }

        @Override
        @Nonnull
        public EggNestTileEntity getExample() {
            EggNestTileEntity te = new EggNestTileEntity();
            te.insertEgg(new ItemStack(Items.field_151110_aK));
            return te;
        }
    };

    private IntegrationHatchery() {
    }
}

