/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.enderio;

import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.soulvial.ItemSoulVial;
import crazypants.enderio.util.CapturedMob;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.converter.ConstantConverter;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.reference.BlockReference;
import org.squiddev.plethora.integration.ItemEntityStorageMetaProvider;
import org.squiddev.plethora.utils.CapabilityWrapper;

@Injects(value="enderio")
public final class IntegrationEnderIO {
    public static final IMetaProvider<ItemStack> META_SOUL_VIAL = new ItemEntityStorageMetaProvider<ItemSoulVial>("capturedEntity", ItemSoulVial.class, "Provides the entity captured inside this Soul Vial."){

        @Override
        @Nullable
        protected Entity spawn(@Nonnull ItemStack stack, @Nonnull ItemSoulVial item, @Nonnull IWorldLocation location) {
            CapturedMob mob = CapturedMob.create((ItemStack)stack);
            return mob == null ? null : mob.getEntity(location.getWorld(), location.getPos(), null, false);
        }

        @Override
        @Nonnull
        protected Map<String, ?> getBasicDetails(@Nonnull ItemStack stack, @Nonnull ItemSoulVial item) {
            CapturedMob mob = CapturedMob.create((ItemStack)stack);
            if (mob == null) {
                return Collections.emptyMap();
            }
            HashMap<String, String> details = new HashMap<String, String>(2);
            details.put("name", mob.getTranslationName());
            details.put("displayName", mob.getDisplayName());
            return details;
        }

        @Override
        @Nullable
        public ItemStack getExample() {
            CapturedMob mob = CapturedMob.create((ResourceLocation)EntityList.func_191306_a(EntityCow.class));
            Item item = ModObject.itemSoulVial.getItem();
            return mob != null && item != null ? mob.toStack(item, 1, 1) : null;
        }
    };
    public static final ConstantConverter<BlockReference, ICapabilityProvider> ENDERIO_CAPABILITIES = x -> {
        TileEntity tile = x.getTileEntity();
        return tile instanceof TileEntityBase && x.getSide() != null ? new CapabilityWrapper((ICapabilityProvider)tile, x.getSide()) : null;
    };

    private IntegrationEnderIO() {
    }
}

