/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.computercraft;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.event.TurtleRefuelEvent;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.squiddev.plethora.gameplay.ConfigGameplay;

final class FERefuelHandler
implements TurtleRefuelEvent.Handler {
    public static final FERefuelHandler INSTANCE = new FERefuelHandler();

    private FERefuelHandler() {
    }

    public int refuel(@Nonnull ITurtleAccess turtle, @Nonnull ItemStack stack, int slot, int limit) {
        int energyExtracted;
        int change;
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        int ratio = ConfigGameplay.Turtle.feFuelRatio;
        if (energy == null || ratio <= 0) {
            return 0;
        }
        if (limit < 0 || limit >= 64 || limit == stack.func_190916_E()) {
            limit = turtle.getFuelLimit() - turtle.getFuelLevel();
        }
        int energyLimit = limit * ratio;
        for (energyExtracted = 0; energyExtracted < energyLimit && (change = energy.extractEnergy(energyLimit - energyExtracted, false)) > 0; energyExtracted += change) {
        }
        return energyExtracted / ratio;
    }
}

