/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.appliedenergistics;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.me.helpers.MachineSource;
import dan200.computercraft.api.peripheral.IComputerAccess;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.TypedLuaObject;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.integration.appliedenergistics.CraftingResult;

public final class MethodCraftItem {
    private MethodCraftItem() {
    }

    @Nonnull
    @PlethoraMethod(modId="appliedenergistics2", doc="-- Craft this item, returning a reference to the crafting task.")
    public static TypedLuaObject<CraftingResult> craft(IContext<IAEItemStack> context, @FromContext IGridNode node, @FromContext IActionHost host, int quantity) {
        IGrid grid = node.getGrid();
        ICraftingGrid crafting = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
        IAEItemStack toCraft = ((IAEItemStack)context.getTarget()).copy();
        toCraft.setStackSize((long)quantity);
        IComputerAccess computer = context.getContext("computer", IComputerAccess.class);
        CraftingResult result = new CraftingResult(grid, computer, host);
        crafting.beginCraftingJob(node.getWorld(), grid, (IActionSource)new MachineSource(host), toCraft, result.getCallback());
        return context.makeChildId(result).getObject();
    }
}

