/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.neural;

import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.squiddev.plethora.gameplay.GuiHandler;
import org.squiddev.plethora.gameplay.ItemBase;
import org.squiddev.plethora.gameplay.neural.ContainerNeuralInterface;
import org.squiddev.plethora.gameplay.neural.ItemComputerHandler;
import org.squiddev.plethora.gameplay.neural.NeuralComputer;
import org.squiddev.plethora.gameplay.neural.NeuralHelpers;
import org.squiddev.plethora.utils.Helpers;
import org.squiddev.plethora.utils.TinySlot;

public class ItemNeuralConnector
extends ItemBase {
    public ItemNeuralConnector() {
        super("neuralConnector", 1);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        TinySlot neuralStack = NeuralHelpers.getSlot((EntityLivingBase)player);
        if (neuralStack == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K) {
            NeuralComputer computer = ItemComputerHandler.getServer(neuralStack.getStack(), (EntityLivingBase)player, neuralStack);
            if (computer != null) {
                computer.turnOn();
            }
            if (!(player.field_71070_bA instanceof ContainerNeuralInterface)) {
                GuiHandler.openNeuralPlayer(player, world);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_111207_a(@Nonnull ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity instanceof EntityPlayer) {
            return false;
        }
        TinySlot neuralStack = NeuralHelpers.getSlot(entity);
        if (neuralStack == null) {
            return false;
        }
        if (!player.func_130014_f_().field_72995_K) {
            NeuralComputer computer = ItemComputerHandler.getServer(neuralStack.getStack(), (EntityLivingBase)player, neuralStack);
            if (computer != null) {
                computer.turnOn();
            }
            if (!(player.field_71070_bA instanceof ContainerNeuralInterface)) {
                GuiHandler.openNeuralEntity(player, player.func_130014_f_(), entity);
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!event.isCanceled() && Helpers.onEntityInteract(this, event.getEntityPlayer(), event.getTarget(), event.getHand())) {
            event.setCanceled(true);
        }
    }
}

