/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.methods;

import dan200.computercraft.api.lua.LuaException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.WorldLocation;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.ArgumentHelper;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.reference.BlockReference;
import org.squiddev.plethora.gameplay.modules.RangeInfo;
import org.squiddev.plethora.integration.vanilla.meta.MetaBlockState;

public final class MethodsScanner {
    private MethodsScanner() {
    }

    @PlethoraMethod(module={"plethora:scanner"}, doc="function():table -- Scan all blocks in the vicinity")
    public static MethodResult scan(IContext<IModuleContainer> context, @FromContext(value={"origin"}) IWorldLocation location, @FromContext(value={"plethora:scanner"}) RangeInfo range) throws LuaException {
        World world = location.getWorld();
        BlockPos pos = location.getPos();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return context.getCostHandler().await((double)range.getBulkCost(), () -> MethodResult.result(MethodsScanner.scan(world, x, y, z, range.getRange())));
    }

    private static Map<Integer, Map<String, ?>> scan(World world, int x, int y, int z, int radius) {
        LuaList result = new LuaList();
        for (int oX = x - radius; oX <= x + radius; ++oX) {
            for (int oY = y - radius; oY <= y + radius; ++oY) {
                for (int oZ = z - radius; oZ <= z + radius; ++oZ) {
                    BlockPos subPos = new BlockPos(oX, oY, oZ);
                    IBlockState block = world.func_180495_p(subPos).func_185899_b((IBlockAccess)world, subPos);
                    HashMap<String, Object> data = new HashMap<String, Object>(6);
                    data.put("x", oX - x);
                    data.put("y", oY - y);
                    data.put("z", oZ - z);
                    ResourceLocation name = block.func_177230_c().getRegistryName();
                    data.put("name", name == null ? "unknown" : name.toString());
                    MetaBlockState.fillBasicMeta(data, block);
                    result.add(data);
                }
            }
        }
        return result.asMap();
    }

    @Nonnull
    @PlethoraMethod(module={"plethora:scanner"}, doc="-- Get metadata about a nearby block")
    public static TypedMeta<BlockReference, ?> getBlockMeta(IContext<IModuleContainer> context, @FromContext(value={"origin"}) IWorldLocation location, @FromContext(value={"plethora:scanner"}) RangeInfo range, int x, int y, int z) throws LuaException {
        int radius = range.getRange();
        ArgumentHelper.assertBetween(x, -radius, radius, "X coordinate out of bounds (%s)");
        ArgumentHelper.assertBetween(y, -radius, radius, "Y coordinate out of bounds (%s)");
        ArgumentHelper.assertBetween(z, -radius, radius, "Z coordinate out of bounds (%s)");
        return context.makeChild(new BlockReference(new WorldLocation(location.getWorld(), location.getPos().func_177982_a(x, y, z)))).getMeta();
    }
}

