/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.methods;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.LuaException;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.squiddev.plethora.api.IPlayerOwnable;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.FromSubtarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.gameplay.ConfigGameplay;
import org.squiddev.plethora.gameplay.PlethoraFakePlayer;
import org.squiddev.plethora.gameplay.modules.ChatListener;
import org.squiddev.plethora.integration.EntityIdentifier;
import org.squiddev.plethora.integration.vanilla.FakePlayerProviderEntity;
import org.squiddev.plethora.integration.vanilla.FakePlayerProviderLocation;

public final class MethodsChat {
    private MethodsChat() {
    }

    @PlethoraMethod(module={"plethora:chat"}, doc="-- Send a message to everyone")
    public static void say(@Nonnull IContext<IModuleContainer> context, @FromContext Entity entity, @FromContext(value={"origin"}) IWorldLocation location, String message) throws LuaException {
        Object player;
        ITextComponent name;
        MethodsChat.validateMessage(message);
        GameProfile moduleProfile = null;
        if (ConfigGameplay.Chat.allowBinding) {
            if (entity == null) {
                entity = context.getContext("plethora:chat", Entity.class);
            }
            IPlayerOwnable moduleOwner = context.getContext("plethora:chat", IPlayerOwnable.class);
            if (ConfigGameplay.Chat.allowOffline && moduleOwner != null) {
                moduleProfile = moduleOwner.getOwningProfile();
            }
        }
        if (entity instanceof EntityPlayerMP) {
            name = entity.func_145748_c_();
            player = (EntityPlayerMP)entity;
        } else if (ConfigGameplay.Chat.allowMobs && entity != null && entity.func_130014_f_() instanceof WorldServer) {
            GameProfile owner;
            IPlayerOwnable ownable = context.getContext("origin", IPlayerOwnable.class);
            GameProfile gameProfile = owner = ownable == null ? null : ownable.getOwningProfile();
            if (owner == null) {
                owner = PlethoraFakePlayer.PROFILE;
            }
            name = entity.func_145748_c_().func_150259_f();
            PlethoraFakePlayer fakePlayer = new PlethoraFakePlayer((WorldServer)entity.func_130014_f_(), entity, owner);
            FakePlayerProviderEntity.load(fakePlayer, entity);
            player = fakePlayer;
        } else if (moduleProfile != null && location != null && location.getWorld() instanceof WorldServer) {
            PlethoraFakePlayer fakePlayer = new PlethoraFakePlayer((WorldServer)location.getWorld(), null, moduleProfile);
            fakePlayer.func_96094_a(moduleProfile.getName());
            FakePlayerProviderLocation.load(fakePlayer, location);
            player = fakePlayer;
            name = fakePlayer.func_145748_c_();
        } else {
            throw new LuaException("Cannot post to chat");
        }
        TextComponentTranslation translateChat = new TextComponentTranslation("chat.type.text", new Object[]{name, ForgeHooks.newChatWithLinks((String)message)});
        ServerChatEvent event = new ServerChatEvent(player, message, (ITextComponent)translateChat);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getComponent() == null) {
            return;
        }
        player.field_71133_b.func_184103_al().func_148544_a(event.getComponent(), false);
    }

    @PlethoraMethod(module={"plethora:chat"}, doc="-- Send a message to yourself")
    public static void tell(@FromSubtarget EntityIdentifier entity, String message) throws LuaException {
        MethodsChat.validateMessage(message);
        EntityLivingBase sender = entity.getEntity();
        sender.func_145747_a(ForgeHooks.newChatWithLinks((String)message));
    }

    static void validateMessage(String message) throws LuaException {
        if (ConfigGameplay.Chat.maxLength > 0 && message.length() > ConfigGameplay.Chat.maxLength) {
            throw new LuaException(String.format("Message is too long (was %d, maximum is %d)", message.length(), ConfigGameplay.Chat.maxLength));
        }
        for (int i = 0; i < message.length(); ++i) {
            char character = message.charAt(i);
            if (character >= ' ' && character != '\u007f' && (character != '\u00a7' || ConfigGameplay.Chat.allowFormatting)) continue;
            throw new LuaException("Illegal character '" + message.charAt(i) + "'");
        }
    }

    @PlethoraMethod(module={"plethora:chat"}, worldThread=false, doc="-- Capture all chat messages matching a Lua pattern, preventing them from being said.")
    public static void capture(@FromContext(value={"plethora:chat"}) ChatListener.Listener listener, String pattern) {
        listener.addPattern(pattern);
    }

    @PlethoraMethod(module={"plethora:chat"}, worldThread=false, doc="-- Remove a capture added by capture(pattern).")
    public static boolean uncapture(@FromContext(value={"plethora:chat"}) ChatListener.Listener listener, String pattern) {
        return listener.removePattern(pattern);
    }

    @PlethoraMethod(module={"plethora:chat"}, worldThread=false, doc="-- Remove all listeners added by capture().")
    public static void clearCaptures(@FromContext(value={"plethora:chat"}) ChatListener.Listener listener) {
        listener.clearPatterns();
    }
}

