/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object2d;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ColourableObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object2d.Positionable2D;
import org.squiddev.plethora.utils.ByteBufUtils;
import org.squiddev.plethora.utils.Vec2d;

public class Rectangle
extends ColourableObject
implements Positionable2D {
    private Vec2d position = Vec2d.ZERO;
    private float width;
    private float height;

    public Rectangle(int id, int parent) {
        super(id, parent, (byte)0);
    }

    @Override
    @Nonnull
    public Vec2d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@Nonnull Vec2d position) {
        if (!Objects.equal((Object)this.position, (Object)position)) {
            this.position = position;
            this.setDirty();
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setSize(float width, float height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.setDirty();
        }
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        super.writeInitial(buf);
        ByteBufUtils.writeVec2d(buf, this.position);
        buf.writeFloat(this.width);
        buf.writeFloat(this.height);
    }

    @Override
    public void readInitial(ByteBuf buf) {
        super.readInitial(buf);
        this.position = ByteBufUtils.readVec2d(buf);
        this.width = buf.readFloat();
        this.height = buf.readFloat();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        Rectangle.setupFlat();
        double minX = this.position.x;
        double minY = this.position.y;
        double maxX = minX + (double)this.width;
        double maxY = minY + (double)this.height;
        int red = this.getRed();
        int green = this.getGreen();
        int blue = this.getBlue();
        int alpha = this.getAlpha();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(minX, minY, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    @PlethoraMethod(doc="function():number, number -- Get the size of this rectangle.", worldThread=false)
    public static MethodResult getSize(@FromTarget Rectangle rect) {
        return MethodResult.result(Float.valueOf(rect.getWidth()), Float.valueOf(rect.getHeight()));
    }

    @PlethoraMethod(doc="-- Set the size of this rectangle.", worldThread=false)
    public static void setSize(@FromTarget Rectangle rect, float width, float height) {
        rect.setSize(width, height);
    }
}

