/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object2d;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.Scalable;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object2d.Polygon;
import org.squiddev.plethora.utils.Vec2d;

public class LineLoop
extends Polygon
implements Scalable {
    private float scale = 1.0f;

    public LineLoop(int id, int parent) {
        super(id, parent, (byte)6);
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        if (this.scale != scale) {
            this.scale = scale;
            this.setDirty();
        }
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        super.writeInitial(buf);
        buf.writeFloat(this.scale);
    }

    @Override
    public void readInitial(ByteBuf buf) {
        super.readInitial(buf);
        this.scale = buf.readFloat();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        if (this.points.size() < 2) {
            return;
        }
        LineLoop.setupFlat();
        GlStateManager.func_187441_d((float)this.scale);
        int red = this.getRed();
        int green = this.getGreen();
        int blue = this.getBlue();
        int alpha = this.getAlpha();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        for (Vec2d point : this.points) {
            buffer.func_181662_b(point.x, point.y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
    }
}

