/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object2d;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.client.FramebufferGlasses;
import org.squiddev.plethora.gameplay.client.OpenGlHelper;
import org.squiddev.plethora.gameplay.client.RenderState;
import org.squiddev.plethora.gameplay.modules.glasses.BaseObject;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ItemObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.Scalable;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object2d.Positionable2D;
import org.squiddev.plethora.utils.ByteBufUtils;
import org.squiddev.plethora.utils.Vec2d;

public class Item2D
extends BaseObject
implements Scalable,
ItemObject,
Positionable2D {
    private float scale;
    private Vec2d position = Vec2d.ZERO;
    private int damage;
    private Item item;
    private ItemStack stack;

    public Item2D(int id, int parent) {
        super(id, parent, (byte)7);
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        if (this.scale != scale) {
            this.scale = scale;
            this.setDirty();
        }
    }

    @Override
    @Nonnull
    public Vec2d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@Nonnull Vec2d position) {
        if (!this.position.equals(position)) {
            this.position = position;
            this.setDirty();
        }
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public void setDamage(int damage) {
        if (this.damage != damage) {
            this.damage = damage;
            this.stack = null;
            this.setDirty();
        }
    }

    @Override
    @Nonnull
    public Item getItem() {
        return this.item;
    }

    @Override
    public void setItem(@Nonnull Item item) {
        if (this.item != item) {
            this.item = item;
            this.stack = null;
            this.setDirty();
        }
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        ByteBufUtils.writeVec2d(buf, this.position);
        buf.writeFloat(this.scale);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.item.getRegistryName().toString());
        buf.writeInt(this.damage);
    }

    @Override
    public void readInitial(ByteBuf buf) {
        this.position = ByteBufUtils.readVec2d(buf);
        this.scale = buf.readFloat();
        ResourceLocation name = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.item = (Item)Item.field_150901_e.func_82594_a((Object)name);
        this.damage = buf.readInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        RenderState state = RenderState.get();
        if (OpenGlHelper.field_148823_f) {
            FramebufferGlasses.ITEM_2D.bindBuffer();
            FramebufferGlasses.clear();
            FramebufferGlasses.ITEM_2D.setupViewport();
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)512.0, (double)288.0, (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.position.x, (double)this.position.y, (double)0.0);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179126_j();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74520_c();
        if (this.stack == null) {
            this.stack = new ItemStack(this.item, 1, this.damage);
        }
        Minecraft.func_71410_x().func_175599_af().func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, this.stack, 0, 0);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        if (OpenGlHelper.field_148823_f) {
            state.restore();
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            FramebufferGlasses.ITEM_2D.bindTexture();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(0.0, 288.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            buffer.func_181662_b(512.0, 288.0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            buffer.func_181662_b(512.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179144_i((int)0);
        }
    }
}

