/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects;

import dan200.computercraft.api.lua.LuaException;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.method.ArgumentHelper;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;

public interface TextObject {
    @Nonnull
    public String getText();

    public void setText(@Nonnull String var1);

    public void setShadow(boolean var1);

    public boolean hasShadow();

    public void setLineHeight(short var1);

    public short getLineHeight();

    @PlethoraMethod(doc="-- Get the text for this object.", worldThread=false)
    public static String getText(@FromTarget TextObject object) {
        return object.getText();
    }

    @PlethoraMethod(doc="-- Set the text for this object.", worldThread=false)
    public static void setText(@FromTarget TextObject object, String contents) throws LuaException {
        ArgumentHelper.assertBetween(contents.length(), 0, 512, "string length out of bounds (%s)");
        object.setText(contents);
    }

    @PlethoraMethod(doc="-- Set the shadow for this object.", worldThread=false)
    public static void setShadow(@FromTarget TextObject object, boolean shadow) {
        object.setShadow(shadow);
    }

    @PlethoraMethod(doc="-- Get the shadow for this object.", worldThread=false)
    public static boolean hasShadow(@FromTarget TextObject object) {
        return object.hasShadow();
    }

    @PlethoraMethod(doc="-- Get the line height for this object.", worldThread=false)
    public static int getLineHeight(@FromTarget TextObject object) {
        return object.getLineHeight();
    }

    @PlethoraMethod(doc="-- Set the line height for this object.", worldThread=false)
    public static void setLineHeight(@FromTarget TextObject object, short lineHeight) {
        object.setLineHeight(lineHeight);
    }
}

