/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasServer;
import org.squiddev.plethora.gameplay.modules.glasses.MessageCanvasUpdate;
import org.squiddev.plethora.gameplay.neural.NeuralHelpers;

@Mod.EventBusSubscriber(modid="plethora")
public final class CanvasHandler {
    public static final int ID_2D = 0;
    public static final int ID_3D = 1;
    public static final int WIDTH = 512;
    public static final int HEIGHT = 288;
    private static final AtomicInteger id = new AtomicInteger(0);
    private static final HashSet<CanvasServer> server = new HashSet();
    private static final Int2ObjectMap<CanvasClient> client = new Int2ObjectOpenHashMap();

    private CanvasHandler() {
    }

    public static int nextId() {
        return id.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServer(CanvasServer canvas) {
        HashSet<CanvasServer> hashSet = server;
        synchronized (hashSet) {
            server.add(canvas);
            Plethora.network.sendTo((IMessage)canvas.getAddMessage(), canvas.getPlayer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeServer(CanvasServer canvas) {
        HashSet<CanvasServer> hashSet = server;
        synchronized (hashSet) {
            server.remove(canvas);
            Plethora.network.sendTo((IMessage)canvas.getRemoveMessage(), canvas.getPlayer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClient(CanvasClient canvas) {
        Int2ObjectMap<CanvasClient> int2ObjectMap = client;
        synchronized (int2ObjectMap) {
            client.put(canvas.id, (Object)canvas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClient(CanvasClient canvas) {
        Int2ObjectMap<CanvasClient> int2ObjectMap = client;
        synchronized (int2ObjectMap) {
            client.remove(canvas.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CanvasClient getClient(int id) {
        Int2ObjectMap<CanvasClient> int2ObjectMap = client;
        synchronized (int2ObjectMap) {
            return (CanvasClient)client.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        HashSet<CanvasServer> hashSet = server;
        synchronized (hashSet) {
            server.clear();
        }
        hashSet = client;
        synchronized (hashSet) {
            client.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void update(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        HashSet<CanvasServer> hashSet = server;
        synchronized (hashSet) {
            for (CanvasServer canvas : server) {
                MessageCanvasUpdate update = canvas.getUpdateMessage();
                if (update == null) continue;
                Plethora.network.sendTo((IMessage)update, canvas.getPlayer());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static CanvasClient getCanvas() {
        EntityPlayerSP playerMP = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = NeuralHelpers.getStack((EntityLivingBase)playerMP);
        if (stack.func_190926_b()) {
            return null;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_150297_b("module_data", 10)) {
            return null;
        }
        NBTTagCompound modules = tag.func_74775_l("module_data");
        if (!modules.func_150297_b("plethora:glasses", 10)) {
            return null;
        }
        NBTTagCompound data = modules.func_74775_l("plethora:glasses");
        if (!data.func_150297_b("id", 99)) {
            return null;
        }
        int id = data.func_74762_e("id");
        return CanvasHandler.getClient(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void render2DOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HELMET) {
            return;
        }
        CanvasClient canvas = CanvasHandler.getCanvas();
        if (canvas == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71466_p == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-100.0f);
        ScaledResolution resolution = event.getResolution();
        GlStateManager.func_179139_a((double)(resolution.func_78327_c() / 512.0), (double)(resolution.func_78324_d() / 288.0), (double)2.0);
        CanvasClient canvasClient = canvas;
        synchronized (canvasClient) {
            canvas.drawChildren(canvas.getChildren(0).iterator());
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onWorldRender(RenderWorldLastEvent event) {
        CanvasClient canvas = CanvasHandler.getCanvas();
        if (canvas == null) {
            return;
        }
        CanvasClient canvasClient = canvas;
        synchronized (canvasClient) {
            canvas.drawChildren(canvas.getChildren(1).iterator());
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
        GlStateManager.func_179118_c();
    }
}

