/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses;

import dan200.computercraft.api.lua.LuaException;
import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.api.reference.ConstantReference;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasServer;

public abstract class BaseObject {
    public static final Comparator<BaseObject> SORTING_ORDER = Comparator.comparingInt(a -> a.id);
    final int id;
    private final byte type;
    private final int parent;
    private boolean dirty = true;

    public BaseObject(int id, int parent, byte type) {
        this.id = id;
        this.parent = parent;
        this.type = type;
    }

    public final int id() {
        return this.id;
    }

    public final int parent() {
        return this.parent;
    }

    public final byte type() {
        return this.type;
    }

    boolean pollDirty() {
        boolean value = this.dirty;
        this.dirty = false;
        return value;
    }

    protected void setDirty() {
        this.dirty = true;
    }

    public abstract void writeInitial(ByteBuf var1);

    public abstract void readInitial(ByteBuf var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void draw(CanvasClient var1);

    @SideOnly(value=Side.CLIENT)
    protected static void setupFlat() {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
    }

    @FunctionalInterface
    public static interface Factory {
        public BaseObject create(int var1, int var2);
    }

    static class BaseObjectReference<T extends BaseObject>
    implements ConstantReference<T> {
        private final CanvasServer canvas;
        private final int id;

        BaseObjectReference(CanvasServer canvas, BaseObject object) {
            this.canvas = canvas;
            this.id = object.id;
        }

        @Override
        @Nonnull
        public T get() throws LuaException {
            BaseObject object = this.canvas.getObject(this.id);
            if (object == null) {
                throw new LuaException("This object has been removed");
            }
            return (T)object;
        }

        @Override
        @Nonnull
        public T safeGet() throws LuaException {
            return (T)this.get();
        }
    }
}

