/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.minecart;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.minecart.EntityMinecartComputer;
import org.squiddev.plethora.gameplay.registry.BasicMessage;

public class MessageMinecartSlot
implements BasicMessage {
    private static final byte FLAG_TAG = 1;
    private static final byte FLAG_STACK = 2;
    private int entityId;
    public int slot;
    private int flags;
    public ItemStack stack;
    public NBTTagCompound tag;

    public MessageMinecartSlot() {
    }

    public MessageMinecartSlot(EntityMinecartComputer minecart, int slot) {
        this.entityId = minecart.func_145782_y();
        this.slot = slot;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
        this.flags |= 2;
    }

    public void setTag(NBTTagCompound tag) {
        this.tag = tag;
        this.flags |= 1;
    }

    public boolean hasTag() {
        return (this.flags & 1) != 0;
    }

    public boolean hasStack() {
        return (this.flags & 2) != 0;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.slot = buf.readByte();
        this.flags = buf.readByte();
        if ((this.flags & 1) != 0) {
            this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }
        if ((this.flags & 2) != 0) {
            this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeByte(this.slot);
        buf.writeByte(this.flags);
        if ((this.flags & 1) != 0) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        }
        if ((this.flags & 2) != 0) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage(MessageContext ctx) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_152345_ab()) {
            mc.func_152344_a(() -> this.onMessage(ctx));
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(this.entityId);
        if (entity instanceof EntityMinecartComputer) {
            EntityMinecartComputer computer = (EntityMinecartComputer)entity;
            if (this.hasStack()) {
                computer.itemHandler.setStackInSlot(this.slot, this.stack);
            }
            if (this.hasTag()) {
                computer.accesses[this.slot].compound = this.tag;
            }
        }
    }
}

