/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.minecart;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.blocks.BlockCommandComputer;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.computer.blocks.ComputerState;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ClientComputerRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.items.ComputerItemFactory;
import dan200.computercraft.shared.computer.items.IComputerItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.IPlayerOwnable;
import org.squiddev.plethora.api.vehicle.IVehicleAccess;
import org.squiddev.plethora.api.vehicle.IVehicleUpgradeHandler;
import org.squiddev.plethora.gameplay.GuiHandler;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.minecart.CommandAPI;
import org.squiddev.plethora.gameplay.minecart.MessageMinecartSlot;
import org.squiddev.plethora.gameplay.minecart.MinecartHelpers;
import org.squiddev.plethora.utils.Helpers;
import org.squiddev.plethora.utils.PlayerHelpers;
import org.squiddev.plethora.utils.RenderHelper;

@Mod.EventBusSubscriber(modid="plethora")
public class EntityMinecartComputer
extends EntityMinecart
implements IPlayerOwnable {
    private static final ComputerFamily[] FAMILIES = ComputerFamily.values();
    private static final ComputerState[] STATES = ComputerState.values();
    private static final ComputerSide[] PERIPHERAL_MAPPINGS = new ComputerSide[]{ComputerSide.TOP, ComputerSide.LEFT, ComputerSide.RIGHT, ComputerSide.BACK};
    private static final AxisAlignedBB[] BOUNDS = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, -1.0, 1.0, 1.0, 0.0), new AxisAlignedBB(0.125, 1.0, -0.875, 0.875, 1.125, -0.125), new AxisAlignedBB(0.125, 0.125, -1.125, 0.875, 0.875, -1.0), new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.125), new AxisAlignedBB(1.0, 0.125, -0.875, 1.125, 0.875, -0.125)};
    private static final DataParameter<Integer> INSTANCE_SLOT = EntityDataManager.func_187226_a(EntityMinecartComputer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SESSION_SLOT = EntityDataManager.func_187226_a(EntityMinecartComputer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> FAMILY_SLOT = EntityDataManager.func_187226_a(EntityMinecartComputer.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> STATE_SLOT = EntityDataManager.func_187226_a(EntityMinecartComputer.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final int SLOTS = 4;
    private int id;
    private boolean on;
    private boolean startOn;
    private GameProfile profile;
    final UpgradeItemHandler itemHandler = new UpgradeItemHandler(4);
    private final IPeripheral[] peripherals = new IPeripheral[4];
    final VehicleAccess[] accesses = new VehicleAccess[4];
    @SideOnly(value=Side.CLIENT)
    private Integer lastClientId;

    public EntityMinecartComputer(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.98f, 0.98f);
        for (int i = 0; i < 4; ++i) {
            this.accesses[i] = new VehicleAccess(this);
        }
    }

    public EntityMinecartComputer(EntityMinecartEmpty minecart, int id, String label, ComputerFamily family, GameProfile profile) {
        this(minecart.func_130014_f_());
        this.func_70080_a(minecart.field_70165_t, minecart.field_70163_u, minecart.field_70161_v, minecart.field_70177_z, minecart.field_70125_A);
        this.field_70159_w = minecart.field_70159_w;
        this.field_70181_x = minecart.field_70181_x;
        this.field_70179_y = minecart.field_70179_y;
        this.setCurrentCartSpeedCapOnRail(minecart.getCurrentCartSpeedCapOnRail());
        this.setMaxSpeedAirLateral(minecart.getMaxSpeedAirLateral());
        this.setMaxSpeedAirVertical(minecart.getMaxSpeedAirVertical());
        this.setDragAir(minecart.getDragAir());
        this.func_70497_h(minecart.func_70496_j());
        this.func_70494_i(minecart.func_70493_k());
        this.id = id;
        this.setFamily(family);
        this.func_96094_a(label == null ? "" : label);
        this.profile = profile;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INSTANCE_SLOT, (Object)-1);
        this.field_70180_af.func_187214_a(SESSION_SLOT, (Object)-1);
        this.field_70180_af.func_187214_a(FAMILY_SLOT, (Object)0);
        this.field_70180_af.func_187214_a(STATE_SLOT, (Object)0);
    }

    private int getInstanceId() {
        return (Integer)this.field_70180_af.func_187225_a(INSTANCE_SLOT);
    }

    private int getSessionId() {
        return (Integer)this.field_70180_af.func_187225_a(SESSION_SLOT);
    }

    public ComputerFamily getFamily() {
        return FAMILIES[(Byte)this.field_70180_af.func_187225_a(FAMILY_SLOT)];
    }

    private void setFamily(ComputerFamily family) {
        this.field_70180_af.func_187227_b(FAMILY_SLOT, (Object)((byte)family.ordinal()));
    }

    public IVehicleAccess getAccess(int slot) {
        return this.accesses[slot];
    }

    private ComputerState getState() {
        return STATES[(Byte)this.field_70180_af.func_187225_a(STATE_SLOT)];
    }

    private void setState(ComputerState state) {
        this.field_70180_af.func_187227_b(STATE_SLOT, (Object)((byte)state.ordinal()));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        computer.setWorld(this.func_130014_f_());
        computer.setPosition(this.func_180425_c());
        if (this.startOn) {
            this.startOn = false;
            computer.turnOn();
        }
        computer.keepAlive();
        String label = computer.getLabel();
        this.func_96094_a(label == null ? "" : label);
        this.on = computer.isOn();
        ComputerState state = ComputerState.Off;
        if (computer.isCursorDisplayed()) {
            state = ComputerState.Blinking;
        } else if (computer.isOn()) {
            state = ComputerState.On;
        }
        this.setState(state);
        WorldServer server = (WorldServer)this.func_130014_f_();
        int stackDirty = this.itemHandler.getDirty();
        this.itemHandler.clearDirty();
        for (int slot = 0; slot < 4; ++slot) {
            IVehicleUpgradeHandler upgrade;
            VehicleAccess access = this.accesses[slot];
            boolean stackChanged = (stackDirty & 1 << slot) != 0;
            boolean accessChanged = access.dirty;
            if (stackChanged) {
                this.accesses[slot].reset();
                upgrade = this.itemHandler.getUpgrade(slot);
                this.peripherals[slot] = upgrade == null ? null : upgrade.create(this.accesses[slot]);
                IPeripheral peripheral = this.peripherals[slot];
                computer.setPeripheral(PERIPHERAL_MAPPINGS[slot], peripheral);
            }
            if ((upgrade = this.itemHandler.getUpgrade(slot)) != null) {
                upgrade.update(access, this.peripherals[slot]);
                accessChanged |= access.dirty;
            }
            access.dirty = false;
            if (!stackChanged && !accessChanged) continue;
            MessageMinecartSlot message = new MessageMinecartSlot(this, slot);
            message.setTag(access.compound);
            if (stackChanged) {
                message.setStack(this.itemHandler.getStackInSlot(slot));
            }
            for (EntityPlayer player : server.func_73039_n().getTrackingPlayers((Entity)this)) {
                Plethora.network.sendTo((IMessage)message, (EntityPlayerMP)player);
            }
        }
    }

    public boolean func_184230_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player, hand))) {
            return true;
        }
        if (!this.func_130014_f_().field_72995_K) {
            Vec3d to;
            int slot;
            Matrix4f trans = this.getTranslationMatrix(1.0f);
            Vec3d from = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            Vec3d look = player.func_70676_i(1.0f);
            double reach = 5.0;
            if (player instanceof EntityPlayerMP) {
                reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
            }
            if ((slot = EntityMinecartComputer.getIntersectSlot(from, to = new Vec3d(from.field_72450_a + look.field_72450_a * reach, from.field_72448_b + look.field_72448_b * reach, from.field_72449_c + look.field_72449_c * reach), trans)) >= 0) {
                ItemStack heldStack = player.func_184586_b(hand);
                ItemStack currentStack = this.itemHandler.getStackInSlot(slot);
                if (heldStack.func_190926_b() && !currentStack.func_190926_b()) {
                    currentStack = this.itemHandler.extractItem(slot, 1, false);
                    if (!player.field_71075_bZ.field_75098_d) {
                        Helpers.spawnItemStack(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, currentStack);
                    }
                } else if (!heldStack.func_190926_b() && currentStack.func_190926_b()) {
                    ItemStack copy = heldStack.func_77946_l();
                    copy.func_190920_e(1);
                    if (this.itemHandler.insertItem(slot, copy, false).func_190926_b() && !player.field_71075_bZ.field_75098_d) {
                        heldStack.func_190917_f(-1);
                        if (heldStack.func_190926_b()) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                    }
                }
                return true;
            }
            if (this.isUsable(player)) {
                ServerComputer computer = this.getServerComputer();
                computer.turnOn();
                GuiHandler.openMinecart(player, player.func_130014_f_(), this);
            }
        }
        return true;
    }

    public void func_70014_b(@Nonnull NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("computerId", this.id);
        tag.func_74774_a("family", (byte)this.getFamily().ordinal());
        tag.func_74757_a("on", this.startOn || this.on);
        tag.func_74782_a("items", (NBTBase)this.itemHandler.serializeNBT());
        PlayerHelpers.writeProfile(tag, this.profile);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.id = tag.func_74762_e("computerId");
        this.setFamily(FAMILIES[tag.func_74771_c("family")]);
        this.startOn |= tag.func_74767_n("on");
        if (tag.func_150297_b("items", 10)) {
            this.itemHandler.deserializeNBT(tag.func_74775_l("items"));
        }
        this.profile = PlayerHelpers.readProfile(tag);
    }

    @Nonnull
    public ServerComputer getServerComputer() {
        ServerComputerRegistry manager = ComputerCraft.serverComputerRegistry;
        int sessionId = manager.getSessionID();
        int instanceId = this.getInstanceId();
        ServerComputer computer = null;
        if (instanceId >= 0 && this.getSessionId() == sessionId) {
            computer = (ServerComputer)manager.get(instanceId);
        }
        if (computer == null) {
            instanceId = manager.getUnusedInstanceID();
            computer = new ServerComputer(this.func_130014_f_(), this.id, this.func_95999_t(), instanceId, this.getFamily(), 51, 19);
            computer.setWorld(this.func_130014_f_());
            computer.setPosition(this.func_180425_c());
            for (int slot = 0; slot < 4; ++slot) {
                IVehicleUpgradeHandler upgrade = this.itemHandler.getUpgrade(slot);
                this.peripherals[slot] = upgrade == null ? null : upgrade.create(this.accesses[slot]);
                IPeripheral peripheral = this.peripherals[slot];
                computer.setPeripheral(PERIPHERAL_MAPPINGS[slot], peripheral);
            }
            if (this.getFamily() == ComputerFamily.Command) {
                computer.addAPI((ILuaAPI)new CommandAPI((Entity)this));
            }
            manager.add(instanceId, computer);
            this.field_70180_af.func_187227_b(SESSION_SLOT, (Object)sessionId);
            this.field_70180_af.func_187227_b(INSTANCE_SLOT, (Object)instanceId);
        }
        return computer;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ClientComputer getClientComputer() {
        ClientComputerRegistry manager = ComputerCraft.clientComputerRegistry;
        int instanceId = this.getInstanceId();
        ClientComputer computer = null;
        if (instanceId >= 0) {
            computer = (ClientComputer)manager.get(instanceId);
        }
        if (computer == null && (this.lastClientId == null || this.lastClientId != instanceId)) {
            computer = new ClientComputer(instanceId);
            manager.add(instanceId, computer);
        }
        if (computer != null) {
            this.lastClientId = instanceId;
        }
        return computer;
    }

    @Nonnull
    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.RIDEABLE;
    }

    public boolean canBeRidden() {
        return false;
    }

    @Nonnull
    public IBlockState func_174897_t() {
        switch (this.getFamily()) {
            default: {
                return ComputerCraft.Blocks.computer.func_176223_P().func_177226_a((IProperty)BlockComputer.Properties.ADVANCED, (Comparable)Boolean.valueOf(this.getFamily() == ComputerFamily.Advanced)).func_177226_a((IProperty)BlockComputer.Properties.STATE, (Comparable)this.getState());
            }
            case Command: 
        }
        return ComputerCraft.Blocks.commandComputer.func_176223_P().func_177226_a((IProperty)BlockCommandComputer.Properties.STATE, (Comparable)this.getState());
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (this.func_130014_f_().func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_70099_a(new ItemStack(Items.field_151143_au, 1), 0.0f);
            ItemStack stack = ComputerItemFactory.create((int)this.id, (String)this.func_95999_t(), (ComputerFamily)this.getFamily());
            this.func_70099_a(stack, 0.0f);
            for (int i = 0; i < 4; ++i) {
                ItemStack child = this.itemHandler.getStackInSlot(i);
                if (child.func_190926_b()) continue;
                this.func_70099_a(child, 0.0f);
            }
        }
    }

    public boolean isUsable(EntityPlayer player) {
        MinecraftServer server;
        if (this.field_70128_L || player.func_70068_e((Entity)this) > 64.0) {
            return false;
        }
        if (this.getFamily() != ComputerFamily.Command) {
            return true;
        }
        if (this.func_130014_f_().field_72995_K) {
            return true;
        }
        MinecraftServer minecraftServer = server = player instanceof EntityPlayerMP ? ((EntityPlayerMP)player).field_71133_b : null;
        if (server == null || !server.func_82356_Z()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("advMode.notEnabled", new Object[0]));
            return false;
        }
        if (!player.func_189808_dh() || !player.field_71075_bZ.field_75098_d) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("advMode.notAllowed", new Object[0]));
            return false;
        }
        return true;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.itemHandler : super.getCapability(capability, facing));
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    private Matrix4f getTranslationMatrix(float partialTicks) {
        long id = (long)this.func_145782_y() * 493286711L;
        id = id * id * 4392167121L + id * 98761L;
        float ox = (((float)(id >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float oy = (((float)(id >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float oz = (((float)(id >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        double x = this.field_70142_S + (this.field_70165_t - this.field_70142_S) * (double)partialTicks;
        double y = this.field_70137_T + (this.field_70163_u - this.field_70137_T) * (double)partialTicks;
        double z = this.field_70136_U + (this.field_70161_v - this.field_70136_U) * (double)partialTicks;
        float pitch = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * partialTicks;
        float yaw = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * partialTicks;
        Vec3d offsetPos = this.func_70489_a(x, y, z);
        if (offsetPos != null) {
            double offset = 0.3;
            Vec3d posOff = MinecartHelpers.getPosOffset(this, x, y, z, 0.3);
            Vec3d negOff = MinecartHelpers.getPosOffset(this, x, y, z, -0.3);
            if (posOff == null) {
                posOff = offsetPos;
            }
            if (negOff == null) {
                negOff = offsetPos;
            }
            x = offsetPos.field_72450_a;
            y = (posOff.field_72448_b + negOff.field_72448_b) / 2.0;
            z = offsetPos.field_72449_c;
            Vec3d invoff = negOff.func_72441_c(-posOff.field_72450_a, -posOff.field_72448_b, -posOff.field_72449_c);
            if (invoff.func_189985_c() != 0.0) {
                invoff = invoff.func_72432_b();
                yaw = (float)(Math.atan2(invoff.field_72449_c, invoff.field_72450_a) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(invoff.field_72448_b) * 73.0);
            }
        }
        Matrix4f temp = new Matrix4f();
        Matrix4f trans = new Matrix4f();
        trans.setIdentity();
        temp.setIdentity();
        temp.setTranslation(new Vector3f((float)x + ox, (float)y + 0.375f + oy, (float)z + oz));
        trans.mul(temp);
        temp.setIdentity();
        temp.rotY((float)Math.toRadians(180.0f - yaw));
        trans.mul(temp);
        temp.setIdentity();
        temp.rotZ((float)Math.toRadians(-pitch));
        trans.mul(temp);
        float amplitude = (float)this.func_70496_j() - partialTicks;
        float roll = this.func_70491_i() - partialTicks;
        if (roll < 0.0f) {
            roll = 0.0f;
        }
        if (amplitude > 0.0f) {
            temp.setIdentity();
            temp.rotX((float)Math.toRadians(MathHelper.func_76126_a((float)amplitude) * amplitude * roll / 10.0f * (float)this.func_70493_k()));
            trans.mul(temp);
        }
        trans.setScale(0.75f);
        int offset = this.func_94099_q();
        temp.setIdentity();
        temp.setTranslation(new Vector3f(-0.5f, (float)(offset - 8) / 16.0f, 0.5f));
        trans.mul(temp);
        return trans;
    }

    private static int getIntersectSlot(Vec3d fromVec, Vec3d toVec, Matrix4f transform) {
        Matrix4f inv = new Matrix4f();
        inv.invert(transform);
        Vector4f to = new Vector4f((float)toVec.field_72450_a, (float)toVec.field_72448_b, (float)toVec.field_72449_c, 1.0f);
        inv.transform((Tuple4f)to);
        Vector4f from = new Vector4f((float)fromVec.field_72450_a, (float)fromVec.field_72448_b, (float)fromVec.field_72449_c, 1.0f);
        inv.transform((Tuple4f)from);
        Vector4f step = new Vector4f();
        step.sub((Tuple4f)to, (Tuple4f)from);
        step.scale(0.01f);
        for (int offset = 0; offset <= 100; ++offset) {
            for (int i = 0; i < BOUNDS.length; ++i) {
                AxisAlignedBB bb = BOUNDS[i];
                if (!bb.func_72318_a(new Vec3d((double)from.getX(), (double)from.getY(), (double)from.getZ()))) continue;
                return i - 1;
            }
            from.add((Tuple4f)step);
        }
        return -1;
    }

    @Override
    @Nullable
    public GameProfile getOwningProfile() {
        return this.profile;
    }

    @SubscribeEvent
    public static void onEntityInteraction(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        Item item = stack.func_77973_b();
        if (item != Item.func_150898_a((Block)ComputerCraft.Blocks.commandComputer) && item != Item.func_150898_a((Block)ComputerCraft.Blocks.computer)) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof EntityMinecartEmpty)) {
            return;
        }
        EntityMinecartEmpty minecart = (EntityMinecartEmpty)target;
        if (minecart.func_94100_s()) {
            return;
        }
        IComputerItem computerItem = (IComputerItem)item;
        int id = computerItem.getComputerID(stack);
        String label = computerItem.getLabel(stack);
        ComputerFamily family = computerItem.getFamily(stack);
        player.func_184609_a(event.getHand());
        if (minecart.func_130014_f_().field_72995_K) {
            return;
        }
        event.setCanceled(true);
        minecart.func_70106_y();
        minecart.func_130014_f_().func_72838_d((Entity)new EntityMinecartComputer(minecart, id, label, family, player.func_146103_bH()));
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190917_f(-1);
            if (stack.func_190926_b()) {
                player.func_184611_a(event.getHand(), ItemStack.field_190927_a);
            }
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof EntityMinecartComputer) {
            EntityMinecartComputer minecart = (EntityMinecartComputer)entity;
            for (int slot = 0; slot < 4; ++slot) {
                ItemStack stack = minecart.itemHandler.getStackInSlot(slot);
                NBTTagCompound tag = minecart.accesses[slot].compound;
                if (stack.func_190926_b() && tag == null) continue;
                MessageMinecartSlot message = new MessageMinecartSlot(minecart, slot);
                message.setStack(stack);
                message.setTag(tag);
                Plethora.network.sendTo((IMessage)message, (EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void drawHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a != RayTraceResult.Type.ENTITY) {
            return;
        }
        if (!(event.getTarget().field_72308_g instanceof EntityMinecartComputer)) {
            return;
        }
        EntityMinecartComputer minecart = (EntityMinecartComputer)event.getTarget().field_72308_g;
        float partialTicks = event.getPartialTicks();
        GlStateManager.func_179094_E();
        Matrix4f trans = minecart.getTranslationMatrix(partialTicks);
        Matrix4f inv = new Matrix4f();
        inv.invert(trans);
        Entity player = Minecraft.func_71410_x().func_175606_aa();
        Vec3d from = player.func_174824_e(partialTicks);
        Vec3d look = player.func_70676_i(partialTicks);
        double reach = 5.0;
        if (player instanceof EntityPlayerMP) {
            reach = ((EntityPlayerMP)player).func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        }
        Vec3d to = new Vec3d(from.field_72450_a + look.field_72450_a * reach, from.field_72448_b + look.field_72448_b * reach, from.field_72449_c + look.field_72449_c * reach);
        int slot = EntityMinecartComputer.getIntersectSlot(from, to, trans);
        GlStateManager.func_179137_b((double)(-(player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks)), (double)(-(player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks)), (double)(-(player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks)));
        ForgeHooksClient.multiplyCurrentGlMatrix((Matrix4f)trans);
        if (slot >= 0) {
            RenderHelper.renderBoundingBox(BOUNDS[slot + 1]);
        }
        GlStateManager.func_179121_F();
        event.setCanceled(true);
    }

    static final class VehicleAccess
    implements IVehicleAccess {
        private final EntityMinecart minecart;
        NBTTagCompound compound;
        boolean dirty = false;

        private VehicleAccess(EntityMinecart minecart) {
            this.minecart = minecart;
        }

        @Nonnull
        public EntityMinecart getVehicle() {
            return this.minecart;
        }

        @Override
        @Nonnull
        public NBTTagCompound getData() {
            NBTTagCompound tag = this.compound;
            if (tag == null) {
                tag = this.compound = new NBTTagCompound();
            }
            return tag;
        }

        @Override
        public void markDataDirty() {
            this.dirty = true;
        }

        public void reset() {
            this.compound = null;
            this.dirty = false;
        }
    }

    static final class UpgradeItemHandler
    extends ItemStackHandler {
        private int dirty = 0;
        private final IVehicleUpgradeHandler[] handlers = new IVehicleUpgradeHandler[6];

        public UpgradeItemHandler(int slots) {
            super(slots);
        }

        protected void onContentsChanged(int slot) {
            this.dirty |= 1 << slot;
            ItemStack stack = this.getStackInSlot(slot);
            this.handlers[slot] = stack.func_190926_b() ? null : (IVehicleUpgradeHandler)stack.getCapability(Constants.VEHICLE_UPGRADE_HANDLER_CAPABILITY, null);
        }

        protected void onLoad() {
            for (int i = 0; i < this.getSlots(); ++i) {
                ItemStack stack = this.getStackInSlot(i);
                this.handlers[i] = stack.func_190926_b() ? null : (IVehicleUpgradeHandler)stack.getCapability(Constants.VEHICLE_UPGRADE_HANDLER_CAPABILITY, null);
            }
        }

        public IVehicleUpgradeHandler getUpgrade(int slot) {
            this.validateSlotIndex(slot);
            return this.handlers[slot];
        }

        public int getDirty() {
            return this.dirty;
        }

        public void clearDirty() {
            this.dirty = 0;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!stack.hasCapability(Constants.VEHICLE_UPGRADE_HANDLER_CAPABILITY, null)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public String toString() {
            return this.stacks.toString();
        }
    }
}

