/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.client.entity;

import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderMinecart;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.vehicle.IVehicleUpgradeHandler;
import org.squiddev.plethora.gameplay.client.RenderHelpers;
import org.squiddev.plethora.gameplay.minecart.EntityMinecartComputer;

public class RenderMinecartComputer
extends RenderMinecart<EntityMinecartComputer> {
    public RenderMinecartComputer(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void doRender(@Nonnull EntityMinecartComputer entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        this.func_180548_c((Entity)entity);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        long id = (long)entity.func_145782_y() * 493286711L;
        id = id * id * 4392167121L + id * 98761L;
        float dx = (((float)(id >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float dy = (((float)(id >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float dz = (((float)(id >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        GlStateManager.func_179109_b((float)dx, (float)dy, (float)dz);
        double ox = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double oy = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double oz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        Vec3d pos = entity.func_70489_a(ox, oy, oz);
        float f3 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
        if (pos != null) {
            Vec3d posOffA = entity.func_70495_a(ox, oy, oz, 0.3);
            Vec3d posOffB = entity.func_70495_a(ox, oy, oz, -0.3);
            if (posOffA == null) {
                posOffA = pos;
            }
            if (posOffB == null) {
                posOffB = pos;
            }
            x += pos.field_72450_a - ox;
            y += (posOffA.field_72448_b + posOffB.field_72448_b) / 2.0 - oy;
            z += pos.field_72449_c - oz;
            Vec3d posOff = posOffB.func_72441_c(-posOffA.field_72450_a, -posOffA.field_72448_b, -posOffA.field_72449_c);
            if (posOff.func_189985_c() != 0.0) {
                posOff = posOff.func_72432_b();
                entityYaw = (float)(Math.atan2(posOff.field_72449_c, posOff.field_72450_a) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(posOff.field_72448_b) * 73.0);
            }
        }
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 0.375f), (float)((float)z));
        GlStateManager.func_179114_b((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-f3), (float)0.0f, (float)0.0f, (float)1.0f);
        float roll = (float)entity.func_70496_j() - partialTicks;
        float damage = entity.func_70491_i() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (roll > 0.0f) {
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)roll) * roll * damage / 10.0f * (float)entity.func_70493_k()), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        GlStateManager.func_179094_E();
        int tileOffset = entity.func_94099_q();
        IBlockState blockState = entity.func_174897_t();
        this.func_110776_a(TextureMap.field_110575_b);
        float scale = 0.75f;
        GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
        GlStateManager.func_179109_b((float)-0.5f, (float)((float)(tileOffset - 8) / 16.0f), (float)0.5f);
        this.func_188319_a(entity, partialTicks, blockState);
        IItemHandler handler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            IBakedModel model;
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            GlStateManager.func_179094_E();
            switch (slot) {
                case 0: {
                    GlStateManager.func_179109_b((float)-0.5f, (float)1.5f, (float)-0.5f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
                    break;
                }
                case 1: {
                    GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)-1.5f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 2: {
                    GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
                    break;
                }
                case 3: {
                    GlStateManager.func_179109_b((float)1.5f, (float)0.5f, (float)-0.5f);
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            IVehicleUpgradeHandler upgrade = (IVehicleUpgradeHandler)stack.getCapability(Constants.VEHICLE_UPGRADE_HANDLER_CAPABILITY, null);
            if (upgrade == null) {
                model = RenderHelpers.getMesher().func_178083_a().func_174951_a();
            } else {
                Pair<IBakedModel, Matrix4f> pair = upgrade.getModel(entity.getAccess(slot));
                ForgeHooksClient.multiplyCurrentGlMatrix((Matrix4f)((Matrix4f)pair.getRight()));
                model = (IBakedModel)pair.getLeft();
            }
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            RenderHelpers.renderModel(model);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_180548_c((Entity)entity);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.field_77013_a.func_78088_a((Entity)entity, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        this.func_177067_a((Entity)entity, x, y, z);
    }
}

