/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.client;

import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.squiddev.plethora.gameplay.ConfigGameplay;
import org.squiddev.plethora.gameplay.modules.ChatMessage;
import org.squiddev.plethora.gameplay.modules.ItemModule;
import org.squiddev.plethora.gameplay.registry.Registration;

@Mod.EventBusSubscriber(modid="plethora", value={Side.CLIENT})
public final class RenderOverlay {
    private static final ResourceLocation TEXTURE = new ResourceLocation("plethora", "textures/misc/flare.png");
    private static int ticks;
    private static final LinkedList<ChatMessage> chatMessages;
    private static final Map<BlockStack, Boolean> oreBlockCache;

    private RenderOverlay() {
    }

    public static void addMessage(ChatMessage message) {
        chatMessages.add(message);
    }

    private static void clearChatMessages() {
        chatMessages.clear();
    }

    @SubscribeEvent
    public static void renderOverlay(RenderWorldLastEvent event) {
        if ((double)(++ticks) > 6283.185307179586) {
            ticks = 0;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        for (EnumHand hand : EnumHand.values()) {
            RenderOverlay.renderOverlay(event, player.func_184586_b(hand));
        }
    }

    @SubscribeEvent
    public static void onConnectionOpened(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        RenderOverlay.clearChatMessages();
    }

    @SubscribeEvent
    public static void onConnectionClosed(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        RenderOverlay.clearChatMessages();
    }

    private static void renderOverlay(RenderWorldLastEvent event, ItemStack stack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        World world = player.func_130014_f_();
        chatMessages.removeIf(ChatMessage::decrement);
        if (stack != null && stack.func_77973_b() == Registration.itemModule) {
            minecraft.func_110434_K().func_110577_a(TEXTURE);
            GlStateManager.func_179097_i();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
            GlStateManager.func_179129_p();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179092_a((int)516, (float)0.01f);
            GlStateManager.func_179094_E();
            RenderManager renderManager = minecraft.func_175598_ae();
            GlStateManager.func_179137_b((double)(-renderManager.field_78730_l), (double)(-renderManager.field_78731_m), (double)(-renderManager.field_78728_n));
            switch (stack.func_77952_i()) {
                case 3: {
                    Vec3d position = player.func_174824_e(event.getPartialTicks());
                    int range = ItemModule.getEffectiveRange(stack, ConfigGameplay.Sensor.radius, ConfigGameplay.Sensor.maxRadius);
                    List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(position.field_72450_a - (double)range, position.field_72448_b - (double)range, position.field_72449_c - (double)range, position.field_72450_a + (double)range, position.field_72448_b + (double)range, position.field_72449_c + (double)range));
                    for (EntityLivingBase entity : entities) {
                        if (entity == player) continue;
                        RenderOverlay.renderFlare(entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, entity.func_145782_y(), 1.0f, renderManager);
                    }
                    break;
                }
                case 2: {
                    BlockPos pos = player.func_180425_c();
                    int x = pos.func_177958_n();
                    int y = pos.func_177956_o();
                    int z = pos.func_177952_p();
                    int range = ItemModule.getEffectiveRange(stack, ConfigGameplay.Scanner.radius, ConfigGameplay.Scanner.maxRadius);
                    for (int oX = x - range; oX <= x + range; ++oX) {
                        for (int oY = y - range; oY <= y + range; ++oY) {
                            for (int oZ = z - range; oZ <= z + range; ++oZ) {
                                IBlockState state = world.func_180495_p(new BlockPos(oX, oY, oZ));
                                Block block = state.func_177230_c();
                                if (!RenderOverlay.isBlockOre(block, block.func_176201_c(state))) continue;
                                RenderOverlay.renderFlare((double)oX + 0.5, (double)oY + 0.5, (double)oZ + 0.5, block.getRegistryName().hashCode(), 1.0f, renderManager);
                            }
                        }
                    }
                    break;
                }
                case 5: 
                case 7: {
                    for (ChatMessage message : chatMessages) {
                        if (message.getWorld() != world.field_73011_w.getDimension()) continue;
                        Vec3d pos = message.getPosition();
                        RenderOverlay.renderFlare(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, message.getId(), (float)message.getCount() * 2.0f / 30.0f, renderManager);
                    }
                    break;
                }
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
        }
    }

    private static boolean isBlockOre(Block block, int meta) {
        if (block == null) {
            return false;
        }
        if (block instanceof BlockOre || block instanceof BlockRedstoneOre) {
            return true;
        }
        if (Item.func_150898_a((Block)block) == Items.field_190931_a) {
            return false;
        }
        BlockStack type = new BlockStack(block, meta);
        Boolean cached = oreBlockCache.get(type);
        if (cached != null) {
            return cached;
        }
        ItemStack stack = new ItemStack(block, 1, meta);
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            String oreName = OreDictionary.getOreName((int)id);
            if (!oreName.contains("ore")) continue;
            oreBlockCache.put(type, true);
            return true;
        }
        oreBlockCache.put(type, false);
        return false;
    }

    private static void renderFlare(double x, double y, double z, int id, float size, RenderManager manager) {
        float offset = (float)((double)id % (Math.PI * 2));
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(-manager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)manager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        Color color = new Color(Color.HSBtoRGB(MathHelper.func_76126_a((float)offset) / 2.0f + 0.5f, MathHelper.func_76134_b((float)offset) / 2.0f + 0.5f, 1.0f));
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.5f);
        RenderOverlay.renderQuad(tessellator, size *= 0.2f + MathHelper.func_76126_a((float)((float)ticks / 100.0f + offset)) / 16.0f);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.2f);
        RenderOverlay.renderQuad(tessellator, size * 2.0f);
        GlStateManager.func_179121_F();
    }

    private static void renderQuad(Tessellator tessellator, float size) {
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(-size), (double)(-size), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(-size), (double)size, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)size, (double)size, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)size, (double)(-size), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    static {
        chatMessages = new LinkedList();
        oreBlockCache = new HashMap<BlockStack, Boolean>();
    }

    private static final class BlockStack {
        public final Block block;
        public final int meta;

        private BlockStack(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlockStack)) {
                return false;
            }
            BlockStack that = (BlockStack)o;
            return this.meta == that.meta && this.block.equals(that.block);
        }

        public int hashCode() {
            int result = this.block.hashCode();
            result = 31 * result + this.meta;
            return result;
        }
    }
}

