/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.wrapper;

import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import dan200.computercraft.api.lua.ILuaObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.MarkerInterfaces;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.method.wrapper.ArgumentType;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.FromSubtarget;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.MethodRegistry;
import org.squiddev.plethora.core.PlethoraCore;
import org.squiddev.plethora.core.wrapper.ArgumentTypeRegistry;
import org.squiddev.plethora.core.wrapper.MethodInstance;
import org.squiddev.plethora.core.wrapper.RenamedMethod;
import org.squiddev.plethora.utils.Helpers;

public final class PlethoraMethodRegistry {
    private static final String[] ORIGIN = new String[]{"origin"};
    private static final Type PARTIAL_CONTEXT_T = IPartialContext.class.getTypeParameters()[0];

    private PlethoraMethodRegistry() {
    }

    static boolean add(Method method) {
        MarkerInterfaces markers;
        Class<?>[] markerIfaces;
        String docs;
        int contextIndex;
        ResourceLocation[] modules;
        PlethoraMethod annotation = method.getAnnotation(PlethoraMethod.class);
        String name = method.getDeclaringClass().getName() + "." + method.getName();
        if (annotation == null) {
            PlethoraCore.LOG.error("@PlethoraMethod method {} is not actually annotated", (Object)name);
            return false;
        }
        int modifiers = method.getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            PlethoraCore.LOG.error("@PlethoraMethod method {} should be public static, but is {}.", (Object)name, (Object)Modifier.toString(modifiers));
            return false;
        }
        String[] moduleNames = annotation.module();
        if (moduleNames.length == 0) {
            moduleNames = null;
            modules = null;
        } else {
            modules = new ResourceLocation[moduleNames.length];
            for (int i = 0; i < moduleNames.length; ++i) {
                modules[i] = new ResourceLocation(moduleNames[i]);
            }
        }
        Class target = null;
        Class<?> subTarget = null;
        ArrayList<MethodInstance.ContextInfo> context = new ArrayList<MethodInstance.ContextInfo>();
        Parameter[] parameters = method.getParameters();
        boolean ok = true;
        for (contextIndex = 0; contextIndex < parameters.length; ++contextIndex) {
            String[] keys;
            Parameter parameter = parameters[contextIndex];
            FromContext fromContext = parameter.getAnnotation(FromContext.class);
            FromTarget fromTarget = parameter.getAnnotation(FromTarget.class);
            FromSubtarget fromSubtarget = parameter.getAnnotation(FromSubtarget.class);
            boolean contextTarget = parameter.getType() == IContext.class || parameter.getType() == IPartialContext.class;
            int counts = 0;
            if (fromContext != null) {
                ++counts;
            }
            if (fromTarget != null) {
                ++counts;
            }
            if (fromSubtarget != null) {
                ++counts;
            }
            if (contextTarget) {
                ++counts;
            }
            if (counts == 0) break;
            if (counts > 1) {
                PlethoraCore.LOG.error("@PlethoraMethod method {}'s has a context argument {} with multiple annotations", (Object)name, (Object)parameter.getName(), (Object)parameter.getType().getName());
                ok = false;
            }
            if (parameter.getAnnotation(Optional.class) != null) {
                if (fromTarget != null || contextTarget) {
                    PlethoraCore.LOG.error("@PlethoraMethod method {}'s target has an @Optional context argument {}.", (Object)name, (Object)parameter.getName());
                    ok = false;
                    continue;
                }
                if (fromSubtarget == null) continue;
                PlethoraCore.LOG.error("@PlethoraMethod method {}'s sub-target has an @Optional context argument {}.", (Object)name, (Object)parameter.getName());
                ok = false;
                continue;
            }
            if (parameter.getClass().isPrimitive()) {
                PlethoraCore.LOG.error("@PlethoraMethod method {}'s has a context argument {} with a primitive type {}", (Object)name, (Object)parameter.getName(), (Object)parameter.getType().getName());
                ok = false;
            }
            if (contextTarget) {
                Type typeParameter = TypeToken.of((Type)parameter.getParameterizedType()).resolveType(PARTIAL_CONTEXT_T).getType();
                Class<?> rawType = PlethoraMethodRegistry.getRawType(parameter, typeParameter);
                if (rawType == null) {
                    ok = false;
                    continue;
                }
                if (target == null) {
                    target = rawType;
                    continue;
                }
                PlethoraCore.LOG.error("@PlethoraMethod method {}'s has multiple targets.", (Object)name);
                ok = false;
                continue;
            }
            if (fromTarget != null) {
                if (PlethoraMethodRegistry.getRawType(parameter) == null) {
                    ok = false;
                }
                if (target == null) {
                    target = parameter.getType();
                    continue;
                }
                PlethoraCore.LOG.error("@PlethoraMethod method {}'s has multiple targets.", (Object)name);
                ok = false;
                continue;
            }
            if (fromSubtarget != null) {
                if (PlethoraMethodRegistry.getRawType(parameter) == null) {
                    ok = false;
                }
                if (subTarget == null) {
                    subTarget = parameter.getType();
                    keys = fromSubtarget.value();
                    if (keys.length == 0) {
                        if (moduleNames == null) {
                            keys = ORIGIN;
                        } else {
                            keys = new String[1 + moduleNames.length];
                            keys[0] = "origin";
                            System.arraycopy(moduleNames, 0, keys, 1, moduleNames.length);
                        }
                    }
                    context.add(new MethodInstance.ContextInfo(keys, parameter.getType()));
                    continue;
                }
                PlethoraCore.LOG.error("@PlethoraMethod method {}'s has multiple sub-targets.", (Object)name);
                ok = false;
                continue;
            }
            if (fromContext != null) {
                if (PlethoraMethodRegistry.getRawType(parameter) == null) {
                    ok = false;
                }
                if ((keys = fromContext.value()).length == 0) {
                    keys = null;
                }
                context.add(new MethodInstance.ContextInfo(keys, parameter.getType()));
                continue;
            }
            throw new IllegalStateException("Fallen through on annotation checks");
        }
        for (int i = contextIndex; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (parameter.getAnnotation(FromContext.class) != null || parameter.getAnnotation(FromTarget.class) != null) {
                PlethoraCore.LOG.error("@PlethoraMethod {} has a context annotation {} after a Lua argument", (Object)name, (Object)parameter.getName());
                ok = false;
            }
            if (PlethoraMethodRegistry.getRawType(parameter) != null) continue;
            ok = false;
        }
        if (target == null) {
            if (modules == null) {
                PlethoraCore.LOG.error("@PlethoraMethod {} has no obvious target.", (Object)name);
                ok = false;
            } else {
                target = IModuleContainer.class;
            }
        }
        if (Strings.isNullOrEmpty((String)(docs = annotation.doc()))) {
            PlethoraCore.LOG.error("@PlethoraMethod {} does not have any documentation.", (Object)name);
            ok = false;
        } else if (!docs.startsWith("function(")) {
            String signature;
            if (!docs.startsWith("-- ")) {
                PlethoraCore.LOG.error("@PlethoraMethod {}'s documentation should start with 'function(' or '--'.", (Object)name);
                ok = false;
            }
            if ((signature = PlethoraMethodRegistry.getSignature(method, name, parameters, contextIndex)) == null) {
                PlethoraCore.LOG.error("@PlethoraMethod {} should specify a signature, due to dynamic arguments or return values.", (Object)name);
                ok = false;
            } else {
                docs = signature + " " + docs;
            }
        }
        String[] names = annotation.name();
        if (names.length == 0) {
            names = new String[]{method.getName()};
        }
        Class<?>[] classArray = markerIfaces = (markers = method.getAnnotation(MarkerInterfaces.class)) == null || markers.value().length == 0 ? null : markers.value();
        if (!ok) {
            return false;
        }
        MethodInstance instance = new MethodInstance(method, target, names[0], docs, annotation.worldThread(), context.toArray(new MethodInstance.ContextInfo[0]), contextIndex, modules, markerIfaces, subTarget);
        PlethoraMethodRegistry.register(target, instance);
        for (int i = 1; i < names.length; ++i) {
            PlethoraMethodRegistry.register(target, new RenamedMethod(names[i], instance));
        }
        return true;
    }

    private static void register(Class<?> target, IMethod<?> instance) {
        MethodRegistry.instance.registerMethod(target, instance);
    }

    private static Class<?> getRawType(Parameter parameter) {
        return PlethoraMethodRegistry.getRawType(parameter, parameter.getParameterizedType());
    }

    private static Class<?> getRawType(Parameter parameter, Type underlying) {
        while (true) {
            if (underlying instanceof Class) {
                return (Class)underlying;
            }
            if (!(underlying instanceof ParameterizedType)) break;
            ParameterizedType type = (ParameterizedType)underlying;
            for (Type arg : type.getActualTypeArguments()) {
                if (arg instanceof WildcardType || arg instanceof TypeVariable && ((TypeVariable)arg).getName().startsWith("capture#")) continue;
                PlethoraCore.LOG.error("@PlethoraMethod {}.{} argument {} has generic type {} with non-wildcard argument {}.", (Object)parameter.getDeclaringExecutable().getDeclaringClass().getName(), (Object)parameter.getDeclaringExecutable().getName(), (Object)parameter.getName(), (Object)parameter.getParameterizedType(), (Object)arg);
                return null;
            }
            underlying = type.getRawType();
        }
        PlethoraCore.LOG.error("@PlethoraMethod {}.{} argument {} has unknown type {}.", (Object)parameter.getDeclaringExecutable().getDeclaringClass().getName(), (Object)parameter.getDeclaringExecutable().getName(), (Object)parameter.getName(), (Object)parameter.getParameterizedType());
        return null;
    }

    public static void loadAsm(ASMDataTable asmDataTable) {
        boolean ok = true;
        for (ASMDataTable.ASMData asmData : asmDataTable.getAll(PlethoraMethod.class.getName())) {
            String className = asmData.getClassName();
            String methodWhole = asmData.getObjectName();
            try {
                if (Helpers.blacklisted(ConfigCore.Blacklist.blacklistProviders, className + "#" + methodWhole)) {
                    PlethoraCore.LOG.debug("Ignoring " + className + "#" + methodWhole);
                    continue;
                }
                String modName = (String)asmData.getAnnotationInfo().get("modId");
                if (!Strings.isNullOrEmpty((String)modName) && !Helpers.modLoaded(modName)) {
                    PlethoraCore.LOG.debug("Skipping " + className + "#" + methodWhole + " as " + modName + " is not loaded or is blacklisted");
                    continue;
                }
                Class<?> klass = Class.forName(className);
                Method method = PlethoraMethodRegistry.findMethod(methodWhole, klass);
                if (method == null) {
                    PlethoraCore.LOG.warn("Cannot find method" + className + "#" + methodWhole + ".");
                    continue;
                }
                PlethoraCore.LOG.debug("Registering " + className + "#" + methodWhole);
                ok &= PlethoraMethodRegistry.add(method);
            }
            catch (Throwable e) {
                PlethoraCore.LOG.error("Failed to load: " + className + "#" + methodWhole, e);
                ok = false;
            }
        }
        if (!ok && ConfigCore.Testing.strict) {
            throw new IllegalStateException("Errors occurred when processing @PlethoraMethod annotations. See the log above for more details.");
        }
    }

    private static Method findMethod(String methodWhole, Class<?> klass) {
        int offset = methodWhole.indexOf(40);
        String methodName = methodWhole.substring(0, offset);
        String methodDesc = methodWhole.substring(offset);
        for (Method method : klass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !org.objectweb.asm.Type.getMethodDescriptor((Method)method).equals(methodDesc)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    private static String getSignature(Method method, String name, Parameter[] parameters, int start) {
        if (start == parameters.length - 1 && parameters[parameters.length - 1].getType() == Object[].class) {
            return null;
        }
        Class<?> ret = method.getReturnType();
        if (ret == MethodResult.class || ret == Object[].class || ret == Object.class) {
            return null;
        }
        StringBuilder builder = new StringBuilder("function(");
        int optDepth = 0;
        for (int i = start; i < parameters.length; ++i) {
            boolean optional;
            Parameter parameter = parameters[i];
            boolean bl = optional = parameter.getAnnotation(Optional.class) != null;
            if (optional) {
                builder.append('[');
                ++optDepth;
            } else {
                while (optDepth > 0) {
                    builder.append(']');
                    --optDepth;
                }
            }
            if (i > start) {
                builder.append(", ");
            }
            builder.append(parameter.getName()).append(':').append(PlethoraMethodRegistry.getTypeName(name, parameter.getType()));
        }
        while (optDepth > 0) {
            builder.append(']');
            --optDepth;
        }
        builder.append(")");
        if (ret != Void.TYPE) {
            boolean optional;
            builder.append(":").append(PlethoraMethodRegistry.getTypeName(name, ret));
            boolean bl = optional = method.getAnnotation(Optional.class) != null;
            if (optional) {
                builder.append("|nil");
            }
        }
        return builder.toString();
    }

    @Nonnull
    private static String getTypeName(String name, Class<?> ty) {
        if (ty.isPrimitive()) {
            if (ty == Long.TYPE || ty == Integer.TYPE || ty == Short.TYPE || ty == Character.TYPE || ty == Byte.TYPE) {
                return "int";
            }
            if (ty == Double.TYPE || ty == Float.TYPE) {
                return "number";
            }
            if (ty == Boolean.TYPE) {
                return "boolean";
            }
            PlethoraCore.LOG.warn("@PlethoraMethod {} has unknown primitive type {}", (Object)name, (Object)ty.getName());
            return ty.getName();
        }
        if (Enum.class.isAssignableFrom(ty)) {
            return "string";
        }
        if (Map.class.isAssignableFrom(ty) || ILuaObject.class.isAssignableFrom(ty)) {
            return "table";
        }
        ArgumentType<?> argTy = ArgumentTypeRegistry.get(ty);
        return argTy == null ? "value" : argTy.name();
    }
}

