/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.converter.IConverter;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.method.wrapper.ArgumentType;
import org.squiddev.plethora.api.transfer.ITransferProvider;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.ConverterRegistry;
import org.squiddev.plethora.core.MetaRegistry;
import org.squiddev.plethora.core.MethodRegistry;
import org.squiddev.plethora.core.PlethoraCore;
import org.squiddev.plethora.core.TransferRegistry;
import org.squiddev.plethora.core.wrapper.ArgumentTypeRegistry;
import org.squiddev.plethora.utils.Helpers;

final class Registry {
    private static final Type TRANSFER_IN = ITransferProvider.class.getTypeParameters()[0];
    private static final Type CONVERTER_IN = IConverter.class.getTypeParameters()[0];
    private static final Type METHOD_IN = IMethod.class.getTypeParameters()[0];
    private static final Type META_IN = IMetaProvider.class.getTypeParameters()[0];
    private static final Type ARGUMENT_TYPE_IN = ArgumentType.class.getTypeParameters()[0];

    private Registry() {
    }

    static void register(ASMDataTable asmDataTable) {
        boolean ok = true;
        for (ASMDataTable.ASMData asmData : asmDataTable.getAll(Injects.class.getName())) {
            String name = asmData.getClassName();
            Map info = asmData.getAnnotationInfo();
            String modId = (String)info.get("value");
            if (!Strings.isNullOrEmpty((String)modId) && !Helpers.modLoaded(modId)) {
                PlethoraCore.LOG.debug("Skipping " + name + " as " + modId + " is not loaded or is blacklisted");
                continue;
            }
            try {
                PlethoraCore.LOG.debug("Injecting " + name);
                if (Helpers.blacklisted(ConfigCore.Blacklist.blacklistProviders, name)) {
                    PlethoraCore.LOG.debug("Ignoring " + name + " as it has been blacklisted");
                    continue;
                }
                Result result = Registry.register(Class.forName(name));
                if (result == Result.PASS) {
                    PlethoraCore.LOG.warn("@Injects class {} has no usable fields or interfaces", (Object)name);
                }
                if (result != Result.ERROR) continue;
                ok = false;
            }
            catch (Exception | LinkageError e) {
                PlethoraCore.LOG.error("@Injects class {} failed to load", (Object)name, (Object)e);
                ok = false;
            }
        }
        if (!ok && ConfigCore.Testing.strict) {
            throw new IllegalStateException("Errors occurred when processing @Injects annotations. See the log above for more details.");
        }
    }

    static Result register(Class<?> klass) {
        String name = klass.getName();
        if (Helpers.blacklisted(ConfigCore.Blacklist.blacklistProviders, name)) {
            PlethoraCore.LOG.debug("Ignoring " + name + " as it has been blacklisted");
            return Result.OK;
        }
        int modifiers = klass.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            PlethoraCore.LOG.error("@Injects class {} should be public final, but is {}", (Object)name, (Object)Modifier.toString(modifiers));
            return Result.ERROR;
        }
        if (!Modifier.isFinal(modifiers)) {
            PlethoraCore.LOG.warn("@Injects class {} should be public final, but is only {}", (Object)name, (Object)Modifier.toString(modifiers));
        }
        Result result = Registry.registerInstance(name, klass, klass, klass, () -> {
            Object value;
            try {
                value = klass.newInstance();
            }
            catch (ReflectiveOperationException e) {
                PlethoraCore.LOG.error("@Injects class {} could not be instantiated", (Object)name, (Object)e);
                return null;
            }
            PlethoraCore.LOG.debug("Registering instance of @Injects class {}", (Object)name);
            return value;
        });
        for (Field field : klass.getDeclaredFields()) {
            result = result.plus(Registry.register(field));
        }
        return result;
    }

    private static Result register(Field field) {
        String name = field.getDeclaringClass().getName() + "." + field.getName();
        if (Helpers.blacklisted(ConfigCore.Blacklist.blacklistProviders, name)) {
            PlethoraCore.LOG.debug("Ignoring " + name + " as it has been blacklisted");
            return Result.OK;
        }
        return Registry.registerInstance(name, field, field.getType(), field.getGenericType(), () -> {
            Object value;
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
                PlethoraCore.LOG.error("@Injects field {} should be public static final, but is {}", (Object)name, (Object)Modifier.toString(modifiers));
                return null;
            }
            if (!Modifier.isFinal(modifiers)) {
                PlethoraCore.LOG.warn("@Injects field {} should be public static final, but is {}", (Object)name, (Object)Modifier.toString(modifiers));
            }
            try {
                value = field.get(null);
            }
            catch (ReflectiveOperationException e) {
                PlethoraCore.LOG.error("@Injects field {}'s value could not be fetched", (Object)name, (Object)e);
                return null;
            }
            PlethoraCore.LOG.debug("Registering value of @Injects field {}", (Object)name);
            return value;
        });
    }

    private static Result registerInstance(String name, AnnotatedElement element, Class<?> rawType, Type type, Supplier<?> instanceGetter) {
        Class<?> klass;
        Type typeParameter;
        Object instance = null;
        if (ITransferProvider.class.isAssignableFrom(rawType)) {
            typeParameter = TypeToken.of((Type)type).resolveType(TRANSFER_IN).getType();
            Class<?> target = Registry.getRawType(name, typeParameter, typeParameter);
            if (target == null) {
                return Result.ERROR;
            }
            if (instance == null) {
                instance = instanceGetter.get();
            }
            if (instance == null) {
                return Result.ERROR;
            }
            ITransferProvider provider = instance;
            if (provider.primary()) {
                TransferRegistry.instance.registerPrimary(target, provider);
            }
            if (provider.secondary()) {
                TransferRegistry.instance.registerSecondary(target, provider);
            }
            if (!provider.primary() && !provider.secondary()) {
                PlethoraCore.LOG.warn("@Injects {} is neither a primary nor secondary ITransferProvider", (Object)name);
            }
        }
        if (IConverter.class.isAssignableFrom(rawType)) {
            typeParameter = TypeToken.of((Type)type).resolveType(CONVERTER_IN).getType();
            klass = Registry.getRawType(name, typeParameter, typeParameter);
            if (klass == null) {
                return Result.ERROR;
            }
            if (instance == null) {
                instance = instanceGetter.get();
            }
            if (instance == null) {
                return Result.ERROR;
            }
            ConverterRegistry.instance.registerConverter(klass, instance);
        }
        if (IMethod.class.isAssignableFrom(rawType)) {
            typeParameter = TypeToken.of((Type)type).resolveType(METHOD_IN).getType();
            klass = Registry.getRawType(name, typeParameter, typeParameter);
            if (klass == null) {
                return Result.ERROR;
            }
            if (instance == null) {
                instance = instanceGetter.get();
            }
            if (instance == null) {
                return Result.ERROR;
            }
            MethodRegistry.instance.registerMethod(klass, instance);
        }
        if (IMetaProvider.class.isAssignableFrom(rawType)) {
            typeParameter = TypeToken.of((Type)type).resolveType(META_IN).getType();
            klass = Registry.getRawType(name, typeParameter, typeParameter);
            if (klass == null) {
                return Result.ERROR;
            }
            if (instance == null) {
                instance = instanceGetter.get();
            }
            if (instance == null) {
                return Result.ERROR;
            }
            MetaRegistry.instance.registerMetaProvider(klass, instance, name);
        }
        if (ArgumentType.class.isAssignableFrom(rawType)) {
            typeParameter = TypeToken.of((Type)type).resolveType(ARGUMENT_TYPE_IN).getType();
            klass = Registry.getRawType(name, typeParameter, typeParameter);
            if (klass == null) {
                return Result.ERROR;
            }
            if (!(element instanceof Field)) {
                PlethoraCore.LOG.error("@Injects {} must be a field in order to be injected as an ArgumentType", (Object)name);
                return Result.ERROR;
            }
            if (instance == null) {
                instance = instanceGetter.get();
            }
            if (instance == null) {
                return Result.ERROR;
            }
            if (!ArgumentTypeRegistry.register(klass, (Field)element)) {
                return Result.ERROR;
            }
        }
        return instance == null ? Result.PASS : Result.OK;
    }

    private static Class<?> getRawType(String name, Type root, Type underlying) {
        while (true) {
            if (underlying instanceof Class) {
                return (Class)underlying;
            }
            if (!(underlying instanceof ParameterizedType)) break;
            ParameterizedType type = (ParameterizedType)underlying;
            for (Type arg : type.getActualTypeArguments()) {
                if (arg instanceof WildcardType || arg instanceof TypeVariable && ((TypeVariable)arg).getName().startsWith("capture#")) continue;
                PlethoraCore.LOG.error("@Injects {} has generic type {} with non-wildcard argument {}", (Object)name, (Object)root, (Object)arg);
                return null;
            }
            underlying = type.getRawType();
        }
        PlethoraCore.LOG.error("@Injects {} has unknown generic type {}", (Object)name, (Object)underlying);
        return null;
    }

    public static enum Result {
        OK,
        ERROR,
        PASS;


        public Result plus(Result other) {
            if (this == ERROR || other == ERROR) {
                return ERROR;
            }
            if (this == OK || other == OK) {
                return OK;
            }
            return PASS;
        }
    }
}

