/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.reference;

import dan200.computercraft.api.lua.LuaException;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.squiddev.plethora.api.reference.ConstantReference;

public class ItemSlot
implements ConstantReference<ItemSlot> {
    private final ItemStack stack;
    private final int slot;
    private final int meta;
    private boolean valid = true;
    @Nonnull
    private final IItemHandler inventory;

    public ItemSlot(@Nonnull IItemHandler inventory, int slot) {
        this.slot = slot;
        this.inventory = inventory;
        this.stack = inventory.getStackInSlot(slot);
        this.meta = this.stack.func_77952_i();
    }

    public void replace(@Nonnull ItemStack newStack) {
        if (newStack.func_190926_b()) {
            newStack = ItemStack.field_190927_a;
        }
        ((IItemHandlerModifiable)this.inventory).setStackInSlot(this.slot, newStack);
    }

    public boolean canReplace() {
        return this.inventory instanceof IItemHandlerModifiable;
    }

    @Nonnull
    public ItemStack extract(int count) {
        return this.inventory.extractItem(this.slot, count, false);
    }

    @Nonnull
    public ItemStack getStack() {
        return this.inventory.getStackInSlot(this.slot);
    }

    @Override
    @Nonnull
    public ItemSlot get() throws LuaException {
        ItemStack newStack = this.inventory.getStackInSlot(this.slot);
        if (newStack != this.stack && (newStack.func_190926_b() || newStack.func_77973_b() != this.stack.func_77973_b() || !this.stack.func_77984_f() && this.meta != newStack.func_77952_i())) {
            this.valid = false;
            throw new LuaException("The stack is no longer there");
        }
        this.valid = true;
        return this;
    }

    @Override
    @Nonnull
    public ItemSlot safeGet() throws LuaException {
        if (!this.valid) {
            throw new LuaException("The stack is no longer there");
        }
        return this;
    }
}

