/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.method;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.method.IPartialContext;

public abstract class BasicMethod<T>
implements IMethod<T> {
    private final String name;
    private final String docs;
    private final int priority;

    public BasicMethod(String name, String docs) {
        this(name, 0, docs);
    }

    public BasicMethod(String name, int priority, String docs) {
        this.name = name;
        this.priority = priority;
        this.docs = Strings.isNullOrEmpty((String)docs) ? null : docs;
    }

    @Override
    @Nonnull
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean canApply(@Nonnull IPartialContext<T> context) {
        return true;
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    @Nonnull
    public String getDocString() {
        return this.docs;
    }
}

