/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.core;

public class EnergyConfig {
    public int minPower = 2;
    public int maxPower = 20;
    public int maxEnergy = 20000;
    public int minPowerLevel = this.maxEnergy / 10;
    public int maxPowerLevel = 9 * this.maxEnergy / 10;
    public int energyRamp = this.maxPowerLevel / this.maxPower;

    public EnergyConfig() {
    }

    public EnergyConfig(EnergyConfig config) {
        this.minPower = config.minPower;
        this.maxPower = config.maxPower;
        this.maxEnergy = config.maxEnergy;
        this.minPowerLevel = config.minPowerLevel;
        this.maxPowerLevel = config.maxPowerLevel;
        this.energyRamp = config.energyRamp;
    }

    public EnergyConfig copy() {
        return new EnergyConfig(this);
    }

    public boolean setDefaultParams(int basePower) {
        this.maxPower = basePower;
        this.minPower = basePower / 10;
        this.maxEnergy = basePower * 1000;
        this.maxPowerLevel = 9 * this.maxEnergy / 10;
        this.minPowerLevel = this.maxEnergy / 10;
        this.energyRamp = this.maxPowerLevel / basePower;
        return true;
    }

    public boolean setDefaultParams(int basePower, boolean smallStorage) {
        if (!smallStorage) {
            return this.setDefaultParams(basePower);
        }
        this.maxPower = basePower;
        this.minPower = basePower;
        this.maxEnergy = basePower * 10;
        this.maxPowerLevel = this.maxPower;
        this.minPowerLevel = this.maxPower - 1;
        this.energyRamp = 1;
        return true;
    }
}

