/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.network;

import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.powertools.machine.capbank.network.ICapBankNetwork;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;

public class NetworkState {
    private final long energyStored;
    private final long maxEnergyStored;
    private final int maxIO;
    private final int maxInput;
    private final int maxOutput;
    @Nonnull
    private final RedstoneControlMode inputMode;
    @Nonnull
    private final RedstoneControlMode outputMode;
    private final float averageInput;
    private final float averageOutput;

    public NetworkState(long energyStored, long maxEnergyStored, int maxIO, int maxInput, int maxOutput, @Nonnull RedstoneControlMode inputMode, @Nonnull RedstoneControlMode outputMode, float averageInput, float averageOutput) {
        this.energyStored = energyStored;
        this.maxEnergyStored = maxEnergyStored;
        this.maxIO = maxIO;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.inputMode = inputMode;
        this.outputMode = outputMode;
        this.averageInput = averageInput;
        this.averageOutput = averageOutput;
    }

    public NetworkState(ICapBankNetwork network) {
        this.energyStored = network.getEnergyStoredL();
        this.maxEnergyStored = network.getMaxEnergyStoredL();
        this.maxIO = network.getMaxIO();
        this.maxInput = network.getMaxInput();
        this.maxOutput = network.getMaxOutput();
        this.inputMode = network.getInputControlMode();
        this.outputMode = network.getOutputControlMode();
        this.averageInput = network.getAverageInputPerTick();
        this.averageOutput = network.getAverageOutputPerTick();
    }

    public long getEnergyStored() {
        return this.energyStored;
    }

    public long getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    public int getMaxOutput() {
        return this.maxOutput;
    }

    public int getMaxInput() {
        return this.maxInput;
    }

    public int getMaxIO() {
        return this.maxIO;
    }

    @Nonnull
    public RedstoneControlMode getInputMode() {
        return this.inputMode;
    }

    @Nonnull
    public RedstoneControlMode getOutputMode() {
        return this.outputMode;
    }

    public float getAverageInput() {
        return this.averageInput;
    }

    public float getAverageOutput() {
        return this.averageOutput;
    }

    public void writeToBuf(@Nonnull ByteBuf buf) {
        buf.writeLong(this.energyStored);
        buf.writeLong(this.maxEnergyStored);
        buf.writeInt(this.maxIO);
        buf.writeInt(this.maxInput);
        buf.writeInt(this.maxOutput);
        buf.writeShort(this.inputMode.ordinal());
        buf.writeShort(this.outputMode.ordinal());
        buf.writeFloat(this.averageInput);
        buf.writeFloat(this.averageOutput);
    }

    public static NetworkState readFromBuf(@Nonnull ByteBuf buf) {
        return new NetworkState(buf.readLong(), buf.readLong(), buf.readInt(), buf.readInt(), buf.readInt(), RedstoneControlMode.values()[buf.readShort()], RedstoneControlMode.values()[buf.readShort()], buf.readFloat(), buf.readFloat());
    }

    public String toString() {
        return "NetworkClientState [energyStored=" + this.energyStored + ", maxEnergyStored=" + this.maxEnergyStored + ", maxIO=" + this.maxIO + ", maxInput=" + this.maxInput + ", maxOutput=" + this.maxOutput + "]";
    }
}

