/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.telepad;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.machine.interfaces.ITEProxy;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.teleport.ContainerTravelAuth;
import crazypants.enderio.machines.machine.teleport.GuiTravelAuth;
import crazypants.enderio.machines.machine.teleport.anchor.BlockTravelAnchor;
import crazypants.enderio.machines.machine.teleport.telepad.TileTelePad;
import crazypants.enderio.machines.machine.teleport.telepad.gui.ContainerAugmentedTravelAccessable;
import crazypants.enderio.machines.machine.teleport.telepad.gui.ContainerTelePad;
import crazypants.enderio.machines.machine.teleport.telepad.gui.GuiAugmentedTravelAccessible;
import crazypants.enderio.machines.machine.teleport.telepad.gui.GuiTelePad;
import crazypants.enderio.machines.machine.teleport.telepad.render.BlockType;
import crazypants.enderio.machines.machine.teleport.telepad.render.TelePadRenderMapper;
import crazypants.enderio.machines.machine.teleport.telepad.render.TelePadSpecialRenderer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTelePad
extends BlockTravelAnchor<TileTelePad>
implements IPaintable.ISolidBlockPaintableBlock,
ITEProxy {
    public static final int GUI_ID_TELEPAD = 0;
    public static final int GUI_ID_TELEPAD_TRAVEL = 1;
    @Nonnull
    public static final PropertyEnum<BlockType> BLOCK_TYPE = PropertyEnum.func_177709_a((String)"blocktype", BlockType.class);

    public static BlockTelePad create_telepad(@Nonnull IModObject modObject) {
        BlockTelePad ret = new BlockTelePad(modObject);
        ret.init();
        return ret;
    }

    public BlockTelePad(@Nonnull IModObject modObject) {
        super(modObject);
        this.func_149713_g(255);
        this.field_149783_u = true;
        this.setShape(this.mkShape(BlockFaceShape.UNDEFINED, BlockFaceShape.SOLID, BlockFaceShape.SOLID));
    }

    @Override
    protected void initDefaultState() {
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)).func_177226_a(BLOCK_TYPE, (Comparable)((Object)BlockType.SINGLE)));
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER, BLOCK_TYPE});
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BLOCK_TYPE, (Comparable)((Object)BlockType.getType(meta))).func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO));
    }

    @Override
    public int func_176201_c(@Nonnull IBlockState state) {
        BlockType type = (BlockType)((Object)state.func_177229_b(BLOCK_TYPE));
        return type.ordinal();
    }

    @Override
    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO));
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileTelePad tileEntity) {
        blockStateWrapper.addCacheKey(blockStateWrapper.func_177229_b((IProperty)BLOCK_TYPE));
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return state.func_177229_b(BLOCK_TYPE) != BlockType.MASTER;
    }

    @Deprecated
    @Nonnull
    public AxisAlignedBB func_180640_a(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos) {
        BlockType bt;
        if (bs.func_177230_c() == this && (bt = (BlockType)((Object)bs.func_177229_b(BLOCK_TYPE))) != BlockType.SINGLE) {
            BlockPos masterLoc = bt.getLocationOfMaster(pos);
            AxisAlignedBB res = new AxisAlignedBB(masterLoc.func_177968_d().func_177968_d().func_177976_e(), masterLoc.func_177978_c().func_177974_f().func_177974_f().func_177984_a());
            return res;
        }
        return super.func_180640_a(bs, world, pos);
    }

    @Override
    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block changedTo, @Nonnull BlockPos fromPos) {
        TileTelePad tileEntity = (TileTelePad)this.getTileEntity((IBlockAccess)world, pos);
        if (tileEntity != null) {
            tileEntity.updateRedstoneState();
        }
    }

    @Override
    protected boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumFacing side) {
        TileTelePad tp;
        BlockType type = (BlockType)((Object)world.func_180495_p(pos).func_177229_b(BLOCK_TYPE));
        BlockPos masterPos = type.getLocationOfMaster(pos);
        if (masterPos != null && (tp = (TileTelePad)this.getTileEntity((IBlockAccess)world, masterPos)) != null) {
            if (tp.canBlockBeAccessed(entityPlayer)) {
                return this.openGui(world, masterPos, entityPlayer, side, 0);
            }
            BlockTelePad.sendPrivateStatusMessage(world, entityPlayer, tp.getOwner());
            return false;
        }
        entityPlayer.func_146105_b((ITextComponent)Lang.STATUS_TELEPAD_UNFORMED.toChatServer(), true);
        return false;
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int ID, @Nonnull TileTelePad te) {
        if (0 == ID) {
            return new ContainerTelePad(player.field_71071_by, te);
        }
        if (1 == ID) {
            return new ContainerAugmentedTravelAccessable(player.field_71071_by, te, world, 6);
        }
        return new ContainerTravelAuth(player.field_71071_by);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int ID, @Nonnull TileTelePad te) {
        if (0 == ID) {
            return new GuiTelePad(player.field_71071_by, te);
        }
        if (1 == ID) {
            return new GuiAugmentedTravelAccessible(player.field_71071_by, te, world);
        }
        return new GuiTravelAuth(player, te, world);
    }

    @Deprecated
    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        BlockPos swCorner = this.findSouthWestCorner(worldIn, pos);
        BlockPos masterPos = this.getMasterPosForNewMB(worldIn, swCorner, pos);
        if (masterPos == null) {
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        }
        Enum myType = null;
        for (BlockType bt : BlockType.values()) {
            BlockPos test = bt.getLocationOfMaster(pos);
            if (test == null || !test.equals((Object)masterPos)) continue;
            myType = bt;
        }
        if (myType == null) {
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        }
        if (!worldIn.field_72995_K) {
            this.updateMultiBlock(worldIn, masterPos, pos, true);
        }
        return this.func_176203_a(myType.ordinal());
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        BlockType type;
        if (state.func_177230_c() == this && (type = (BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) != BlockType.SINGLE) {
            BlockPos masterPos = type.getLocationOfMaster(pos);
            this.updateMultiBlock(worldIn, masterPos, pos, false);
        }
    }

    private void updateMultiBlock(World world, BlockPos masterPos, BlockPos ignorePos, boolean form) {
        for (BlockType type : BlockType.values()) {
            if (type == BlockType.SINGLE) continue;
            Vec3i offset = type.getOffsetFromMaster();
            BlockPos targetPos = new BlockPos(masterPos.func_177958_n() + offset.func_177958_n(), masterPos.func_177956_o() + offset.func_177956_o(), masterPos.func_177952_p() + offset.func_177952_p());
            if (targetPos.equals((Object)ignorePos)) continue;
            BlockType setToType = BlockType.SINGLE;
            if (form) {
                setToType = type;
            }
            world.func_180501_a(targetPos, this.func_176223_P().func_177226_a(BLOCK_TYPE, (Comparable)((Object)setToType)), 3);
        }
    }

    private BlockPos getMasterPosForNewMB(@Nonnull World worldIn, @Nonnull BlockPos swCorner, @Nonnull BlockPos ignorePos) {
        BlockPos testPos = swCorner;
        for (int i = 0; i < 3; ++i) {
            testPos = swCorner.func_177967_a(EnumFacing.NORTH, i);
            for (int j = 0; j < 3; ++j) {
                if (!testPos.equals((Object)ignorePos) && !this.isSingle(worldIn, testPos)) {
                    return null;
                }
                testPos = testPos.func_177974_f();
            }
        }
        return swCorner.func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.EAST);
    }

    @Nonnull
    private BlockPos findSouthWestCorner(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        int i;
        BlockPos res = pos;
        for (i = 0; this.isSingle(worldIn, res.func_177968_d()) && i < 2; ++i) {
            res = res.func_177968_d();
        }
        for (i = 0; this.isSingle(worldIn, res.func_177976_e()) && i < 2; ++i) {
            res = res.func_177976_e();
        }
        return res;
    }

    private boolean isSingle(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        IBlockState bs = worldIn.func_180495_p(pos);
        if (bs.func_177230_c() == this) {
            return bs.func_177229_b(BLOCK_TYPE) == BlockType.SINGLE;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return TelePadRenderMapper.instance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return TelePadRenderMapper.instance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileTelePad.class, (TileEntitySpecialRenderer)new TelePadSpecialRenderer());
    }

    @Override
    @Nullable
    public TileEntity getParent(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return this.getTileEntity(world, (BlockPos)NullHelper.first((Object[])new BlockPos[]{((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))).getLocationOfMaster(pos), pos}));
    }
}

