/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.tank;

import com.enderio.core.common.network.MessageTileEntity;
import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.machines.machine.tank.TileTank;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTankFluid
extends MessageTileEntity<TileTank> {
    private NBTTagCompound nbtRoot;

    public PacketTankFluid() {
    }

    public PacketTankFluid(@Nonnull TileTank tile) {
        super((TileEntity)tile);
        this.nbtRoot = tile.tank.writeToNBT(new NBTTagCompound());
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)this.nbtRoot, (ByteBuf)buf);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.nbtRoot = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<PacketTankFluid, IMessage> {
        public IMessage onMessage(PacketTankFluid message, MessageContext ctx) {
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            TileTank tile = (TileTank)message.getTileEntity(player.field_70170_p);
            if (tile != null) {
                tile.tank.readFromNBT(message.nbtRoot);
                tile.updateLight();
            }
            return null;
        }
    }
}

