/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.init;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.IModTileEntity;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.conduit.item.ItemFunctionUpgrade;
import crazypants.enderio.base.init.IModObjectBase;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.init.RegisterModObject;
import crazypants.enderio.base.registry.Registry;
import crazypants.enderio.conduits.conduit.BlockConduitBundle;
import crazypants.enderio.conduits.conduit.item.ItemItemConduit;
import crazypants.enderio.conduits.conduit.liquid.ItemLiquidConduit;
import crazypants.enderio.conduits.conduit.power.ItemPowerConduit;
import crazypants.enderio.conduits.conduit.redstone.ItemRedstoneConduit;
import crazypants.enderio.conduits.init.ConduitTileEntity;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderioconduits")
public enum ConduitObject implements IModObjectBase
{
    block_conduit_bundle(BlockConduitBundle::create, ConduitTileEntity.TileConduitBundle),
    item_item_conduit(ItemItemConduit::create),
    item_liquid_conduit(ItemLiquidConduit::create),
    item_power_conduit(ItemPowerConduit::create),
    item_redstone_conduit(ItemRedstoneConduit::create),
    item_extract_speed_upgrade(ItemFunctionUpgrade::createUpgrade),
    item_extract_speed_downgrade(ItemFunctionUpgrade::createDowngrade);

    @Nonnull
    final String unlocalisedName = ModObjectRegistry.sanitizeName((String)NullHelper.notnullJ((Object)this.name(), (String)"Enum.name()"));
    @Nullable
    protected Block block;
    @Nullable
    protected Item item;
    @Nullable
    protected final IModTileEntity modTileEntity;
    @Nullable
    protected final Function<IModObject, Block> blockMaker;
    @Nullable
    protected final BiFunction<IModObject, Block, Item> itemMaker;

    @SubscribeEvent
    public static void registerBlocksEarly(@Nonnull RegisterModObject event) {
        Registry.registerConduitBlock(block_conduit_bundle);
        event.register(ConduitObject.class);
    }

    private ConduitObject(BiFunction<IModObject, Block, Item> itemMaker) {
        this(null, itemMaker, null);
    }

    private ConduitObject(Function<IModObject, Block> blockMaker) {
        this(blockMaker, null, null);
    }

    private ConduitObject(Function<IModObject, Block> blockMaker, BiFunction<IModObject, Block, Item> itemMaker) {
        this(blockMaker, itemMaker, null);
    }

    private ConduitObject(Function<IModObject, Block> blockMaker, IModTileEntity modTileEntity) {
        this(blockMaker, null, modTileEntity);
    }

    private ConduitObject(@Nullable Function<IModObject, Block> blockMaker, BiFunction<IModObject, Block, Item> itemMaker, IModTileEntity modTileEntity) {
        this.blockMaker = blockMaker;
        this.itemMaker = itemMaker;
        if (blockMaker == null && itemMaker == null) {
            throw new RuntimeException(this + " unexpectedly is neither a Block nor an Item.");
        }
        this.modTileEntity = modTileEntity;
    }

    @Override
    @Nonnull
    public final String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    @Nullable
    public final Block getBlock() {
        return this.block;
    }

    @Nullable
    public final Item getItem() {
        return this.item;
    }

    @Override
    @Nullable
    public final Class<?> getClazz() {
        return null;
    }

    @Override
    public final String getBlockMethodName() {
        return null;
    }

    @Override
    public final String getItemMethodName() {
        return null;
    }

    @Override
    public final void setItem(@Nullable Item obj) {
        this.item = obj;
    }

    @Override
    public final void setBlock(@Nullable Block obj) {
        this.block = obj;
    }

    @Override
    @Nullable
    public IModTileEntity getTileEntity() {
        return this.modTileEntity;
    }

    @Override
    @Nonnull
    public Function<IModObject, Block> getBlockCreator() {
        return this.blockMaker != null ? this.blockMaker : mo -> null;
    }

    @Override
    @Nonnull
    public BiFunction<IModObject, Block, Item> getItemCreator() {
        return (BiFunction)NullHelper.first((Object[])new BiFunction[]{this.itemMaker, IModObject.WithBlockItem.itemCreator});
    }

    @Override
    @Nonnull
    public final <B extends Block> B apply(@Nonnull B blockIn) {
        blockIn.func_149647_a(EnderIOTab.tabEnderIOConduits);
        return IModObjectBase.super.apply(blockIn);
    }
}

