/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.me.conduit;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.conduit.me.conduit.IMEConduit;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MEConduitGrid
implements IGridBlock {
    private final IMEConduit conduit;

    public MEConduitGrid(IMEConduit conduit) {
        this.conduit = conduit;
    }

    public double getIdlePowerUsage() {
        return 0.0;
    }

    public AEColor getGridColor() {
        return AEColor.TRANSPARENT;
    }

    public EnumSet<EnumFacing> getConnectableSides() {
        return this.conduit.getConnections();
    }

    public ItemStack getMachineRepresentation() {
        return this.conduit.createItem();
    }

    public EnumSet<GridFlags> getFlags() {
        return this.conduit.isDense() ? EnumSet.of(GridFlags.DENSE_CAPACITY) : EnumSet.noneOf(GridFlags.class);
    }

    public boolean isWorldAccessible() {
        return true;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.conduit.getBundle().getEntity());
    }

    public void onGridNotification(GridNotification notification) {
    }

    public void setNetworkStatus(IGrid grid, int channelsInUse) {
    }

    public IGridHost getMachine() {
        IConduitBundle bundle = this.conduit.getBundle();
        if (bundle instanceof IGridHost) {
            return (IGridHost)bundle;
        }
        throw new IllegalStateException("Bundle was null or not an IGridHost. Maybe a mixin issue? Bundle: " + bundle);
    }

    public void gridChanged() {
        World world = this.conduit.getBundle().getBundleworld();
        BlockPos pos = this.conduit.getBundle().getLocation();
        this.conduit.onNeighborBlockChange(world.func_180495_p(pos).func_177230_c());
    }
}

