/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.sound;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.events.ModSoundRegisterEvent;
import crazypants.enderio.base.sound.IModSound;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderio")
public enum SoundRegistry implements IModSound
{
    ZOMBIE_BUBBLE(SoundCategory.BLOCKS, "generator.zombie.bubble"),
    NIGHTVISION_ON(SoundCategory.PLAYERS, "ds.nightvision.on"),
    NIGHTVISION_OFF(SoundCategory.PLAYERS, "ds.nightvision.off"),
    JUMP(SoundCategory.PLAYERS, "ds.jump"),
    TELEPAD(SoundCategory.BLOCKS, "telepad.teleport"),
    TRAVEL_SOURCE_BLOCK(SoundCategory.BLOCKS, new ResourceLocation("entity.endermen.teleport")),
    TRAVEL_SOURCE_ITEM(SoundCategory.PLAYERS, new ResourceLocation("entity.endermen.teleport")),
    ITEM_BURN(SoundCategory.BLOCKS, new ResourceLocation("entity.generic.burn")),
    TAB_SWITCH(SoundCategory.MASTER, "tab.switch");

    @Nonnull
    private final ResourceLocation resourceLocation;
    @Nonnull
    private final SoundCategory soundCategory;
    @Nullable
    private SoundEvent soundEvent = null;

    private SoundRegistry(SoundCategory soundCategory, ResourceLocation resourceLocation) {
        this.soundCategory = soundCategory;
        this.resourceLocation = resourceLocation;
    }

    private SoundRegistry(SoundCategory soundCategory, String name) {
        this(soundCategory, new ResourceLocation("enderio", name));
    }

    @SubscribeEvent
    public static void registerSounds(@Nonnull ModSoundRegisterEvent event) {
        for (SoundRegistry soundRegistry : SoundRegistry.values()) {
            if (SoundEvent.field_187505_a.func_148741_d((Object)soundRegistry.resourceLocation)) {
                soundRegistry.soundEvent = (SoundEvent)event.getRegistry().getValue(soundRegistry.resourceLocation);
                continue;
            }
            SoundEvent soundEvent_nullchecked = soundRegistry.soundEvent = new SoundEvent(soundRegistry.resourceLocation);
            event.getRegistry().register(soundEvent_nullchecked.setRegistryName(soundRegistry.resourceLocation));
        }
    }

    @Override
    public boolean isValid() {
        return this.soundEvent != null;
    }

    @Override
    @Nonnull
    public SoundEvent getSoundEvent() {
        return (SoundEvent)NullHelper.notnull((Object)this.soundEvent, (String)"trying to play unregistered sound");
    }

    @Override
    @Nonnull
    public SoundCategory getSoundCategory() {
        return this.soundCategory;
    }
}

