/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.registry;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.ICustomItemResourceLocation;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IDefaultRenderers;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.ITintedBlock;
import crazypants.enderio.base.render.ITintedItem;
import crazypants.enderio.base.render.model.RelayingBakedModel;
import crazypants.enderio.base.render.pipeline.OverlayHolder;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.base.render.registry.PaintTintHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class SmartModelAttacher {
    private static final List<RegistrationHolder> blocks = new ArrayList<RegistrationHolder>();

    public static void register(@Nonnull Block block) {
        SmartModelAttacher.register(block, EnumRenderMode.RENDER, EnumRenderMode.DEFAULTS, EnumRenderMode.AUTO);
    }

    public static void registerNoProps(@Nonnull Block block) {
        SmartModelAttacher.register(block, null, null, null, false);
    }

    public static void registerItemOnly(@Nonnull Block block) {
        SmartModelAttacher.register(block, null, null, null, true);
    }

    public static <T extends Comparable<T>, V extends T> void register(@Nonnull Block block, IProperty<T> property, V defaultsValue, V autoValue) {
        SmartModelAttacher.register(block, property, defaultsValue, autoValue, false);
    }

    private static <T extends Comparable<T>, V extends T> void register(@Nonnull Block block, IProperty<T> property, V defaultsValue, V autoValue, boolean itemOnly) {
        blocks.add(new RegistrationHolder<T, V>(block, property, defaultsValue, autoValue, itemOnly));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerBlockItemModels(ModelRegistryEvent event) {
        for (RegistrationHolder holder : blocks) {
            Block block = holder.block;
            IModObject modObject = ModObjectRegistry.getModObject(holder.block);
            if (modObject == null) {
                Log.debug("Block " + block + " has no modObject. What?");
                continue;
            }
            Item item = modObject.getItem();
            if (item instanceof IHaveRenderers || block instanceof IHaveRenderers) {
                Log.debug(block.getClass() + " handles its item registrations itself");
                if (!(item instanceof ICustomSubItems) && !(block instanceof ICustomSubItems)) continue;
                throw new RuntimeException(block.getClass() + " implements both IHaveRenderers and ICustomSubItems");
            }
            if (block instanceof IDefaultRenderers) {
                Log.debug(block.getClass() + " has default item registrations");
                if (!(item instanceof ICustomSubItems) && !(block instanceof ICustomSubItems)) continue;
                throw new RuntimeException(block.getClass() + " implements both IDefaultRenderers and ICustomSubItems");
            }
            if (item != null && item != Items.field_190931_a) {
                ResourceLocation registryName = item instanceof ICustomItemResourceLocation ? ((ICustomItemResourceLocation)item).getRegistryNameForCustomModelResourceLocation() : (ResourceLocation)NullHelper.notnullF((Object)item.getRegistryName(), (String)"Item.getItemFromBlock() returned an unregistered item");
                ModelResourceLocation location = new ModelResourceLocation(registryName, "inventory");
                if (item.func_77614_k()) {
                    NNList<ItemStack> subItems;
                    if (item instanceof ICustomSubItems) {
                        subItems = ((ICustomSubItems)item).getSubItems();
                    } else if (block instanceof ICustomSubItems) {
                        subItems = ((ICustomSubItems)block).getSubItems();
                    } else {
                        throw new RuntimeException(block.getClass() + " has subitems but it does not implement ICustomSubItems");
                    }
                    for (ItemStack itemStack : subItems) {
                        Log.debug("Registering RL " + location + " for " + itemStack);
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)itemStack.func_77952_i(), (ModelResourceLocation)location);
                    }
                    continue;
                }
                Log.debug("Registering RL " + location + " for " + item);
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)location);
                continue;
            }
            Log.debug("Block " + block + " has no item, is it intended?");
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerColoredBlocksAndItems(EnderIOLifecycleEvent.Init.Post event) {
        NNList blocklist = new NNList();
        NNList itemlist = new NNList();
        for (RegistrationHolder holder : blocks) {
            Block block = holder.block;
            Item item = Item.func_150898_a((Block)block);
            if (block instanceof IPaintable || block instanceof ITintedBlock || block instanceof ITintedItem || item instanceof ITintedItem) {
                blocklist.add((Object)block);
                if (item == Items.field_190931_a) continue;
                itemlist.add((Object)item);
                continue;
            }
            if (block instanceof IBlockColor) {
                Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)block, new Block[]{block});
            }
            if (!(item instanceof IItemColor)) continue;
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)item, new Item[]{item});
        }
        PaintTintHandler handler = new PaintTintHandler();
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)handler, (Block[])blocklist.toArray((Object[])new Block[0]));
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)handler, (Item[])itemlist.toArray((Object[])new Item[0]));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void bakeModels(@Nonnull ModelBakeEvent event) {
        for (RegistrationHolder holder : blocks) {
            IBakedModel defaultBakedModel;
            ModelResourceLocation defaultMrl;
            IBlockState defaultState;
            Block block = holder.block;
            Map locations = event.getModelManager().func_174954_c().func_178120_a().func_188181_b(block);
            IProperty holder_property = holder.property;
            Object holder_defaultsValue = holder.defaultsValue;
            IBakedModel missingModel = event.getModelManager().func_174951_a();
            if (holder_property != null && block.func_176223_P().func_177227_a().contains(holder_property) && holder_defaultsValue != null) {
                defaultState = block.func_176223_P().func_177226_a(holder_property, holder_defaultsValue);
                defaultMrl = (ModelResourceLocation)locations.get(defaultState);
                if (defaultMrl == null) {
                    throw new RuntimeException("Model for state " + defaultState + " failed to load from " + defaultMrl + ". " + SmartModelAttacher.debugOutput((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry(), block.getRegistryName(), missingModel));
                }
                defaultBakedModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)defaultMrl);
                if (defaultBakedModel == null) {
                    Log.warn("ModelBakeEvent: cannot register smart model over null model for " + holder.block + ". See model errors below.");
                    continue;
                }
                RelayingBakedModel model = new RelayingBakedModel(defaultBakedModel);
                ModelResourceLocation itemMrl = new ModelResourceLocation(defaultMrl.func_110624_b() + ":" + defaultMrl.func_110623_a() + "#inventory");
                event.getModelRegistry().func_82595_a((Object)itemMrl, (Object)model);
                if (defaultBakedModel == missingModel) continue;
                for (Map.Entry entry : locations.entrySet()) {
                    ModelResourceLocation entryMrl = (ModelResourceLocation)NullHelper.notnullF(entry.getValue(), (String)"BlockModelShapes contains null keys");
                    IBlockState entryBlockstate = (IBlockState)entry.getKey();
                    IBakedModel existingModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)entryMrl);
                    if (existingModel == null || existingModel == missingModel) {
                        event.getModelRegistry().func_82595_a((Object)entryMrl, (Object)defaultBakedModel);
                        continue;
                    }
                    if (entryBlockstate.func_177229_b(holder_property) != holder.autoValue) continue;
                    event.getModelRegistry().func_82595_a((Object)entryMrl, (Object)model);
                }
                continue;
            }
            defaultState = block.func_176223_P();
            defaultMrl = (ModelResourceLocation)locations.get(defaultState);
            if (defaultMrl == null) {
                throw new RuntimeException("Model for state " + defaultState + " failed to load from " + defaultMrl + ". " + SmartModelAttacher.debugOutput((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry(), block.getRegistryName(), missingModel));
            }
            defaultBakedModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)defaultMrl);
            if (defaultBakedModel == null || defaultBakedModel == missingModel) continue;
            if (!holder.itemOnly) {
                for (ModelResourceLocation mrl0 : locations.values()) {
                    ModelResourceLocation mrl = (ModelResourceLocation)NullHelper.notnullF((Object)mrl0, (String)"BlockModelShapes contains null keys");
                    IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl);
                    if (model == null || model == missingModel) continue;
                    event.getModelRegistry().func_82595_a((Object)mrl, (Object)new RelayingBakedModel((IBakedModel)NullHelper.first((Object[])new IBakedModel[]{model, defaultBakedModel})));
                }
            }
            ModelResourceLocation itemMrl = new ModelResourceLocation(defaultMrl.func_110624_b() + ":" + defaultMrl.func_110623_a() + "#inventory");
            IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)itemMrl);
            if (model == null || model == missingModel) {
                event.getModelRegistry().func_82595_a((Object)itemMrl, (Object)new RelayingBakedModel(defaultBakedModel));
                continue;
            }
            event.getModelRegistry().func_82595_a((Object)itemMrl, (Object)new RelayingBakedModel(model));
        }
        OverlayHolder.collectOverlayQuads(event);
    }

    private static String debugOutput(IRegistry<ModelResourceLocation, IBakedModel> modelRegistry, ResourceLocation defaultMrl, IBakedModel missingModel) {
        String prefix = defaultMrl.func_110624_b() + ":" + defaultMrl.func_110623_a();
        if (modelRegistry instanceof RegistrySimple) {
            RegistrySimple rg = (RegistrySimple)modelRegistry;
            StringBuilder sb = new StringBuilder();
            for (Object key : rg.func_148742_b()) {
                if (key == null || modelRegistry.func_82594_a((Object)((ModelResourceLocation)key)) == missingModel || !key.toString().startsWith(prefix)) continue;
                sb.append(key + "; ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            } else {
                sb.append("(none)");
            }
            return "Loaded states for " + prefix + " are: " + sb.toString();
        }
        return "Loaded states could not be determined because modelRegistry is not a RegistrySimple.";
    }

    private static class RegistrationHolder<T extends Comparable<T>, V extends T> {
        @Nonnull
        final Block block;
        final IProperty<T> property;
        final V defaultsValue;
        final V autoValue;
        boolean itemOnly;

        protected RegistrationHolder(@Nonnull Block block, IProperty<T> property, V defaultsValue, V autoValue, boolean itemOnly) {
            this.block = block;
            this.property = property;
            this.defaultsValue = defaultsValue;
            this.autoValue = autoValue;
            this.itemOnly = itemOnly;
        }
    }
}

