/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.spawner;

import com.enderio.core.common.util.NNList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public final class EntityDataRegistry {
    private static final EntityDataRegistry instance = new EntityDataRegistry();
    private double defaultCostMultiplier = 1.0;
    private boolean defaultBlacklistedSpawning = false;
    private boolean defaultBlacklistedSoulvial = false;
    private boolean defaultNeedsCloning = false;
    @Nonnull
    private final NNList<Entry> entries = new NNList();

    public static EntityDataRegistry getInstance() {
        return instance;
    }

    @Nullable
    private Entry getByIdentity(@Nonnull Object identity) {
        return this.entries.stream().filter(elem -> identity.equals(elem.identity)).findFirst().orElse(null);
    }

    public double getCostMultiplierFor(@Nonnull ResourceLocation entity) {
        return this.entries.stream().filter(elem -> elem.selector.test(entity) && elem.cost > 0.0).map(elem -> elem.cost).reduce(Double::max).orElse(this.defaultCostMultiplier);
    }

    public boolean isBlackListedForSpawning(@Nonnull ResourceLocation entity) {
        return this.entries.stream().filter(elem -> elem.selector.test(entity)).map(elem -> elem.blacklistedSpawning).reduce(Boolean::logicalOr).orElse(this.defaultBlacklistedSpawning);
    }

    public boolean isBlackListedForSoulVial(@Nonnull ResourceLocation entity) {
        return this.entries.stream().filter(elem -> elem.selector.test(entity)).map(elem -> elem.blacklistedSoulvial).reduce(Boolean::logicalOr).orElse(this.defaultBlacklistedSoulvial);
    }

    public boolean needsCloning(@Nonnull ResourceLocation entity) {
        return this.entries.stream().filter(elem -> elem.selector.test(entity)).map(elem -> elem.needsCloning).reduce(Boolean::logicalOr).orElse(this.defaultNeedsCloning);
    }

    private EntityDataRegistry() {
        ResourceLocation DRAGON = new ResourceLocation("minecraft", "ender_dragon");
        this.addEntityData(null, in -> DRAGON.equals(in), Double.MAX_VALUE, true, true, true);
    }

    public void setDefaults(double costMultiplier, boolean blacklistedSpawning, boolean blacklistedSoulvial, boolean needsCloning) {
        this.defaultCostMultiplier = costMultiplier;
        this.defaultBlacklistedSpawning = blacklistedSpawning;
        this.defaultBlacklistedSoulvial = blacklistedSoulvial;
        this.defaultNeedsCloning = needsCloning;
    }

    @Deprecated
    public void addToBlacklistSpawning(@Nonnull ResourceLocation value) {
        this.addToBlacklistSpawning(value, in -> value.equals(in));
    }

    @Deprecated
    public void addToBlacklistSpawning(@Nonnull Predicate<ResourceLocation> entityFilter) {
        this.addToBlacklistSpawning(null, entityFilter);
    }

    public void addToBlacklistSpawning(@Nullable Object identity, @Nonnull Predicate<ResourceLocation> entityFilter) {
        Entry entry;
        Entry entry2 = entry = identity != null ? this.getByIdentity(identity) : null;
        if (entry != null) {
            this.entries.remove((Object)entry);
        } else {
            entry = new Entry(identity, entityFilter);
        }
        this.entries.add((Object)entry.withBlacklistedSpawning(true));
    }

    public void addToBlacklistSoulVial(@Nullable Object identity, @Nonnull Predicate<ResourceLocation> entityFilter) {
        Entry entry;
        Entry entry2 = entry = identity != null ? this.getByIdentity(identity) : null;
        if (entry != null) {
            this.entries.remove((Object)entry);
        } else {
            entry = new Entry(identity, entityFilter);
        }
        this.entries.add((Object)entry.withBlacklistedSoulvial(true));
    }

    public void setNeedsCloning(@Nullable Object identity, @Nonnull Predicate<ResourceLocation> entityFilter) {
        Entry entry;
        Entry entry2 = entry = identity != null ? this.getByIdentity(identity) : null;
        if (entry != null) {
            this.entries.remove((Object)entry);
        } else {
            entry = new Entry(identity, entityFilter);
        }
        this.entries.add((Object)entry.withNeedsCloning(true));
    }

    @Deprecated
    public void addEntityCost(@Nonnull ResourceLocation value, double costMultiplier) {
        this.addEntityCost(value, in -> value.equals(in), costMultiplier);
    }

    @Deprecated
    public void addEntityCost(@Nonnull Predicate<ResourceLocation> entityFilter, double costMultiplier) {
        this.addEntityCost(null, entityFilter, costMultiplier);
    }

    public void addEntityCost(@Nullable Object identity, @Nonnull Predicate<ResourceLocation> entityFilter, double costMultiplier) {
        if (costMultiplier > 0.0) {
            Entry entry;
            Entry entry2 = entry = identity != null ? this.getByIdentity(identity) : null;
            if (entry != null) {
                this.entries.remove((Object)entry);
            } else {
                entry = new Entry(identity, entityFilter);
            }
            this.entries.add((Object)entry.withCost(costMultiplier));
        }
    }

    public void addEntityData(@Nullable Object identity, @Nonnull Predicate<ResourceLocation> entityFilter, double costMultiplier, boolean blacklistedSpawning, boolean blacklistedSoulvial, boolean needsCloning) {
        Entry entry;
        Entry entry2 = entry = identity != null ? this.getByIdentity(identity) : null;
        if (entry != null) {
            this.entries.remove((Object)entry);
        }
        this.entries.add((Object)new Entry(identity, entityFilter, costMultiplier, blacklistedSpawning, blacklistedSoulvial, needsCloning));
    }

    private static class Entry {
        @Nullable
        final Object identity;
        @Nonnull
        final Predicate<ResourceLocation> selector;
        final double cost;
        final boolean blacklistedSpawning;
        final boolean blacklistedSoulvial;
        final boolean needsCloning;

        Entry(@Nullable Object identity, @Nonnull Predicate<ResourceLocation> selector) {
            this(identity, selector, 0.0, false, false, false);
        }

        Entry(@Nullable Object identity, @Nonnull Predicate<ResourceLocation> selector, double cost, boolean blacklistedSpawning, boolean blacklistedSoulvial, boolean needsCloning) {
            this.identity = identity;
            this.selector = selector;
            this.cost = cost;
            this.blacklistedSpawning = blacklistedSpawning;
            this.blacklistedSoulvial = blacklistedSoulvial;
            this.needsCloning = needsCloning;
        }

        @Nonnull
        Entry withCost(double cost) {
            return new Entry(this.identity, this.selector, cost, this.blacklistedSpawning, this.blacklistedSoulvial, this.needsCloning);
        }

        @Nonnull
        Entry withBlacklistedSpawning(boolean blacklistedSpawning) {
            return new Entry(this.identity, this.selector, this.cost, blacklistedSpawning, this.blacklistedSoulvial, this.needsCloning);
        }

        @Nonnull
        Entry withBlacklistedSoulvial(boolean blacklistedSoulvial) {
            return new Entry(this.identity, this.selector, this.cost, this.blacklistedSpawning, blacklistedSoulvial, this.needsCloning);
        }

        @Nonnull
        Entry withNeedsCloning(boolean needsCloning) {
            return new Entry(this.identity, this.selector, this.cost, this.blacklistedSpawning, this.blacklistedSoulvial, needsCloning);
        }
    }
}

