/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.gui;

import com.enderio.core.client.gui.IDrawingElement;
import com.enderio.core.client.gui.widget.GuiToolTip;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;

public class GenericBar
implements IDrawingElement {
    @Nonnull
    private final GuiContainerBaseEIO owner;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int color;
    @Nullable
    private final GuiToolTip tooltip;

    public GenericBar(@Nonnull GuiContainerBaseEIO owner, int x, int y, int width, int height, int color, @Nullable GuiToolTip tooltip) {
        this.owner = owner;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
        this.tooltip = tooltip;
    }

    public GenericBar(@Nonnull GuiContainerBaseEIO owner, Rectangle r, int color, @Nullable GuiToolTip tooltip) {
        this(owner, r.x, r.y, r.width, r.height, color, tooltip);
    }

    @Nullable
    public GuiToolTip getTooltip() {
        return this.tooltip;
    }

    public void drawGuiContainerBackgroundLayer(float partialTicks, int par2, int par3) {
        int drawX = this.owner.getGuiLeft() + this.x;
        int barWidth = this.width;
        int barHeight = this.getLevelScaled(this.height);
        int yOffset = this.y + this.height - barHeight;
        int drawY = this.owner.getGuiTop() + yOffset;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.owner.func_73733_a(drawX, drawY, drawX + barWidth, drawY + barHeight, this.getColor(), this.getColor());
        GlStateManager.func_179084_k();
    }

    protected int getColor() {
        return this.color;
    }

    protected float getLevel() {
        return 0.0f;
    }

    protected int getLevelScaled(int scale) {
        return (int)MathHelper.func_76131_a((float)(this.getLevel() * (float)scale), (float)0.0f, (float)scale);
    }
}

