/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.base.te;

import com.enderio.core.common.inventory.Callback;
import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.base.capability.Filters;
import crazypants.enderio.base.machine.base.network.PacketPowerStorage;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.machine.base.te.ICap;
import crazypants.enderio.base.machine.base.te.IEnergyLogic;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.power.IEnergyTank;
import crazypants.enderio.util.NbtValue;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EnergyLogic
implements IEnergyLogic,
ICap.NNFunction,
Callback<ItemStack> {
    @Nonnull
    public static final String CAPSLOT = "cap";
    @Nonnull
    private final AbstractCapabilityMachineEntity owner;
    @Nonnull
    private final IEnergyTank energy;
    @Nonnull
    private final Random random = new Random();
    private float lastSyncPowerStored = -1.0f;
    private long lastSyncPowerTick = -1L;
    private boolean isCapacitorDamageable = false;

    public EnergyLogic(AbstractCapabilityMachineEntity owner, @Nonnull IEnergyTank energy) {
        this.owner = (AbstractCapabilityMachineEntity)NullHelper.notnull((Object)owner, (String)"Logic Error: Owner missing");
        this.energy = energy;
        owner.getInventory().add(EnderInventory.Type.UPGRADE, CAPSLOT, new InventorySlot(Filters.CAPACITORS, null, (Callback)this, 1));
        this.updateCapacitorFromSlot();
        owner.addICap(CapabilityEnergy.ENERGY, ICap.facedOnly(this));
    }

    @Override
    public void serverTick() {
        this.energy.loseEnergy();
        int scaledPower = this.getScaledPower();
        if (this.lastSyncPowerStored != (float)scaledPower && (this.lastSyncPowerStored == 0.0f || scaledPower == 0 || this.lastSyncWasLongAgo())) {
            this.lastSyncPowerStored = scaledPower;
            PacketHandler.sendToAllAround((IMessage)new PacketPowerStorage(this.owner), (TileEntity)this.owner);
        }
    }

    private boolean lastSyncWasLongAgo() {
        long tick = this.owner.func_145831_w().func_82737_E();
        if (tick != this.lastSyncPowerTick) {
            this.lastSyncPowerTick = tick;
            return true;
        }
        return false;
    }

    @Override
    public void processTasks(boolean redstoneCheck) {
        if (redstoneCheck) {
            this.damageCapacitor();
        }
    }

    @Override
    public int getScaledPower() {
        if (this.getEnergy().getEnergyStored() == 0) {
            return 0;
        }
        return 1 + this.getEnergy().getEnergyStored() / 1000;
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    @Override
    public boolean hasPower() {
        return this.getEnergy().getEnergyStored() > 0;
    }

    @Override
    @Nonnull
    public ICapacitorData getCapacitorData() {
        return this.getEnergy().getCapacitorData();
    }

    @Override
    @Nonnull
    public IEnergyTank getEnergy() {
        return this.energy;
    }

    public final void onChange(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
        this.updateCapacitorFromSlot();
    }

    @Override
    public void updateCapacitorFromSlot() {
        InventorySlot slot = this.owner.getInventory().getSlot(CAPSLOT);
        if (this.getEnergy().updateCapacitorFromSlot(slot)) {
            this.isCapacitorDamageable = slot.get().func_77984_f();
            this.owner.onCapacitorDataChange();
        }
    }

    @Override
    public void damageCapacitor() {
        ItemStack cap;
        if (this.isCapacitorDamageable && (cap = this.owner.getInventory().getSlot(CAPSLOT).get()).func_96631_a(1, this.random, null)) {
            this.owner.getInventory().getSlot(CAPSLOT).clear();
        }
    }

    @Override
    public void readCustomNBT(@Nonnull ItemStack stack) {
        this.energy.setEnergyStored(NbtValue.ENERGY.getInt(stack));
    }

    @Override
    public void writeCustomNBT(@Nonnull ItemStack stack) {
        NbtValue.ENERGY.setInt(stack, this.energy.getEnergyStored());
        NbtValue.ENERGY_BUFFER.setInt(stack, this.energy.getMaxEnergyStored());
    }

    public IEnergyStorage apply(@Nonnull EnumFacing facingIn) {
        return this.owner.getIoMode(facingIn).canInputOrOutput() ? this.getEnergy().get(facingIn) : null;
    }
}

