/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.natura;

import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.base.farming.farmers.PickableFarmer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class NaturaBerryFarmer
extends PickableFarmer {
    public NaturaBerryFarmer(@Nonnull Block plantedBlock, int plantedBlockMeta, int grownBlockMeta, @Nonnull ItemStack seeds) {
        super(plantedBlock, plantedBlockMeta, grownBlockMeta, seeds);
        this.requiresTilling = false;
        this.checkGroundForFarmland = false;
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IBlockState stateIn) {
        IBlockState state = stateIn;
        Block block = state.func_177230_c();
        if (block != this.getPlantedBlock()) {
            return null;
        }
        if (!farm.hasTool(FarmingTool.HOE)) {
            farm.setNotification(FarmNotification.NO_HOE);
            return null;
        }
        HarvestResult res = new HarvestResult();
        BlockPos checkBlock = bc;
        while (checkBlock != null && checkBlock.func_177956_o() <= 255 && farm.hasTool(FarmingTool.HOE)) {
            IHarvestResult blockRes;
            state = farm.getBlockState(checkBlock);
            block = state.func_177230_c();
            if (block != this.getPlantedBlock()) {
                checkBlock = null;
                continue;
            }
            if (this.getFullyGrownBlockMeta() == block.func_176201_c(state) && (blockRes = super.harvestBlock(farm, checkBlock, state)) != null) {
                res.getHarvestedBlocks().add((Object)checkBlock);
                res.getDrops().addAll(blockRes.getDrops());
            }
            checkBlock = checkBlock.func_177984_a();
        }
        if (res.getHarvestedBlocks().isEmpty()) {
            return null;
        }
        return res;
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        BlockPos checkBlock = pos;
        Block block = state.func_177230_c();
        while (checkBlock.func_177956_o() <= 255) {
            if (block != this.getPlantedBlock()) {
                return false;
            }
            if (super.canHarvest(farm, checkBlock, state)) {
                return true;
            }
            checkBlock = checkBlock.func_177984_a();
            state = farm.getBlockState(checkBlock);
            block = state.func_177230_c();
        }
        return false;
    }
}

