/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeWrapper
implements IRecipeWrapper {
    protected final IRecipe recipe;

    public RecipeWrapper(IRecipe recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        NNList<List<ItemStack>> inputStacks = this.recipe.getInputStackAlternatives();
        ingredients.setInputLists(ItemStack.class, inputStacks);
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (RecipeOutput out : this.recipe.getOutputs()) {
            if (!Prep.isValid(out.getOutput())) continue;
            outputs.add(out.getOutput());
        }
        ingredients.setOutputs(ItemStack.class, outputs);
        NNList<FluidStack> inputFluidStacks = this.recipe.getInputFluidStacks();
        if (inputFluidStacks != null) {
            ingredients.setInputs(FluidStack.class, inputFluidStacks);
        }
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>();
        for (RecipeOutput out : this.recipe.getOutputs()) {
            if (out.getFluidOutput() == null) continue;
            fluidOutputs.add(out.getFluidOutput());
        }
        ingredients.setOutputs(FluidStack.class, fluidOutputs);
    }

    public boolean isValid() {
        return this.recipe != null && this.recipe.isValid();
    }

    public int getEnergyRequired() {
        return this.recipe.getEnergyRequired();
    }

    public IRecipe getRecipe() {
        return this.recipe;
    }

    public RecipeBonusType getBonusType() {
        return this.recipe.getBonusType();
    }
}

