/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.util.Prep;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class JeiHidingRegistry {
    @Nonnull
    private static final Map<IConfiguredIngredient<?>, IConfiguredIngredient<?>> DATA = new HashMap();

    @Nonnull
    public static NNList<Object> getObjectsToHide() {
        NNList result = new NNList();
        for (IConfiguredIngredient<?> ci : DATA.keySet()) {
            result.addAll(ci.get());
        }
        return result;
    }

    public static void set(@Nonnull Things thing, boolean show, boolean hide) {
        for (ItemStack stack : thing.getItemStacksRaw()) {
            if (stack == null) continue;
            JeiHidingRegistry.set(stack, show, hide);
        }
    }

    public static void set(@Nonnull ItemStack stack, boolean show, boolean hide) {
        if (Prep.isValid(stack)) {
            ConfiguredItemstack cis = new ConfiguredItemstack(stack);
            if (DATA.containsKey(cis)) {
                cis = (ConfiguredItemstack)DATA.get(cis);
            } else {
                DATA.put(cis, cis);
            }
            cis.set(stack, show, hide);
        }
    }

    public static void set(@Nonnull Fluid fluid, boolean show, boolean hide) {
        ConfiguredFluidstack cis = new ConfiguredFluidstack(fluid);
        if (DATA.containsKey(cis)) {
            cis = (ConfiguredFluidstack)DATA.get(cis);
        } else {
            DATA.put(cis, cis);
        }
        cis.set(new FluidStack(fluid, 1), show, hide);
    }

    public static void set(@Nonnull FluidStack stack, boolean show, boolean hide) {
        ConfiguredFluidstack cis = new ConfiguredFluidstack(stack.getFluid());
        if (DATA.containsKey(cis)) {
            cis = (ConfiguredFluidstack)DATA.get(cis);
        } else {
            DATA.put(cis, cis);
        }
        cis.set(stack, show, hide);
    }

    private static class ConfiguredFluidstack
    implements IConfiguredIngredient<FluidStack> {
        @Nonnull
        private final Fluid fluid;
        private boolean shown = false;
        private boolean hidden = false;

        ConfiguredFluidstack(Fluid fluid) {
            this.fluid = (Fluid)NullHelper.notnull((Object)fluid, (String)"Encountered Forge fluid stack without fluid");
        }

        @Override
        @Nonnull
        public NNList<Object> get() {
            return !this.shown || this.hidden ? this.makeResult() : NNList.emptyList();
        }

        @Nonnull
        private NNList<Object> makeResult() {
            NNList result = new NNList();
            result.add((Object)new FluidStack(this.fluid, 1));
            ItemStack bucket = Fluids.getBucket(this.fluid);
            if (Prep.isValid(bucket)) {
                result.add((Object)bucket);
            }
            return result;
        }

        public int hashCode() {
            return this.fluid.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfiguredFluidstack other = (ConfiguredFluidstack)obj;
            return this.fluid == other.fluid;
        }

        @Override
        public void set(@Nonnull FluidStack v, boolean show, boolean hide) {
            if (v.getFluid() != this.fluid) {
                throw new UnsupportedOperationException("Cannot configure fluid '" + v.getFluid() + "' using configuration of fluid '" + this.fluid + "'");
            }
            this.shown |= show;
            this.hidden |= hide;
        }
    }

    private static class ConfiguredItemstack
    implements IConfiguredIngredient<ItemStack> {
        @Nonnull
        private final Item item;
        @Nonnull
        private final BitSet isset = new BitSet();
        @Nonnull
        private final BitSet shown = new BitSet();
        @Nonnull
        private final BitSet hidden = new BitSet();

        ConfiguredItemstack(@Nonnull ItemStack v) {
            this.item = v.func_77973_b();
        }

        @Override
        @Nonnull
        public NNList<ItemStack> get() {
            NNList list = new NNList();
            if (this.isset.get(Short.MAX_VALUE)) {
                if (!this.shown.get(Short.MAX_VALUE) || this.hidden.get(Short.MAX_VALUE)) {
                    this.addStack((NNList<ItemStack>)list, new ItemStack(this.item, 1, Short.MAX_VALUE));
                }
            } else {
                int i = this.isset.nextSetBit(0);
                while (i >= 0 && i < Short.MAX_VALUE) {
                    if (!this.shown.get(i) || this.hidden.get(i)) {
                        this.addStack((NNList<ItemStack>)list, new ItemStack(this.item, 1, i));
                    }
                    i = this.isset.nextSetBit(i + 1);
                }
            }
            return list;
        }

        private void addStack(@Nonnull NNList<ItemStack> list, @Nonnull ItemStack stack) {
            list.add((Object)stack);
            NNList temp = new NNList();
            for (CreativeTabs tab : this.item.getCreativeTabs()) {
                if (tab == null) continue;
                this.item.func_150895_a(tab, (NonNullList)temp);
            }
            for (ItemStack tabStack : temp) {
                if (stack.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != tabStack.func_77952_i()) continue;
                list.add((Object)tabStack);
            }
        }

        public int hashCode() {
            return this.item.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfiguredItemstack other = (ConfiguredItemstack)obj;
            return this.item == other.item;
        }

        @Override
        public void set(@Nonnull ItemStack v, boolean show, boolean hide) {
            if (v.func_77973_b() != this.item) {
                throw new UnsupportedOperationException("Cannot configure item '" + v.func_77973_b() + "' using configuration of item '" + this.item + "'");
            }
            if (show) {
                this.shown.set(v.func_77952_i());
            }
            if (hide) {
                this.hidden.set(v.func_77952_i());
            }
            this.isset.set(v.func_77952_i());
        }
    }

    private static interface IConfiguredIngredient<V> {
        @Nonnull
        public NNList<? extends Object> get();

        public void set(@Nonnull V var1, boolean var2, boolean var3);
    }
}

