/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.gui;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Camera;
import com.enderio.core.common.vecmath.Matrix4d;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.machine.modes.PacketIoMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.teleport.TravelController;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class IoConfigRenderer<E extends TileEntity> {
    public static final TextureRegistry.TextureSupplier selectedFaceIcon = TextureRegistry.registerTexture("blocks/overlays/selected_face");
    private boolean dragging = false;
    private float pitch = 0.0f;
    private float yaw = 0.0f;
    private double distance;
    private long initTime;
    @Nonnull
    private Minecraft mc = Minecraft.func_71410_x();
    @Nonnull
    private World world;
    @Nonnull
    private final Vector3d origin;
    @Nonnull
    private final Vector3d eye;
    @Nonnull
    private final Camera camera;
    @Nonnull
    private final Matrix4d pitchRot;
    @Nonnull
    private final Matrix4d yawRot;
    @Nonnull
    private NNList<BlockPos> configurables;
    @Nonnull
    private NNList<BlockPos> neighbours;
    private SelectedFace<E> selection;
    private boolean renderNeighbours;
    private boolean inNeigButBounds;

    @SubscribeEvent
    public static void init(@Nonnull EnderIOLifecycleEvent.PreInit event) {
    }

    public IoConfigRenderer(@Nonnull IIoConfigurable configuarble) {
        this((NNList<BlockPos>)new NNList((Object[])new BlockPos[]{configuarble.getLocation()}));
    }

    public IoConfigRenderer(final @Nonnull NNList<BlockPos> configurables) {
        Vector3d size;
        Vector3d c;
        this.world = this.mc.field_71439_g.field_70170_p;
        this.origin = new Vector3d();
        this.eye = new Vector3d();
        this.camera = new Camera();
        this.pitchRot = new Matrix4d();
        this.yawRot = new Matrix4d();
        this.configurables = new NNList();
        this.neighbours = new NNList();
        this.renderNeighbours = true;
        this.inNeigButBounds = false;
        this.configurables.addAll(configurables);
        if (configurables.size() == 1) {
            BlockPos bc = (BlockPos)configurables.get(0);
            c = new Vector3d((double)bc.func_177958_n() + 0.5, (double)bc.func_177956_o() + 0.5, (double)bc.func_177952_p() + 0.5);
            size = new Vector3d(1.0, 1.0, 1.0);
        } else {
            Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
            for (BlockPos bc : configurables) {
                min.set(Math.min((double)bc.func_177958_n(), min.x), Math.min((double)bc.func_177956_o(), min.y), Math.min((double)bc.func_177952_p(), min.z));
                max.set(Math.max((double)bc.func_177958_n(), max.x), Math.max((double)bc.func_177956_o(), max.y), Math.max((double)bc.func_177952_p(), max.z));
            }
            size = new Vector3d(max);
            size.sub(min);
            size.scale(0.5);
            c = new Vector3d(min.x + size.x, min.y + size.y, min.z + size.z);
            size.scale(2.0);
        }
        this.origin.set(c);
        this.pitchRot.setIdentity();
        this.yawRot.setIdentity();
        this.pitch = -this.mc.field_71439_g.field_70125_A;
        this.yaw = 180.0f - this.mc.field_71439_g.field_70177_z;
        this.distance = Math.max(Math.max(size.x, size.y), size.z) + 4.0;
        configurables.apply((NNList.Callback)new NNList.Callback<BlockPos>(){

            public void apply(final @Nonnull BlockPos pos) {
                NNList.FACING.apply((NNList.Callback)new NNList.Callback<EnumFacing>(){

                    public void apply(@Nonnull EnumFacing dir) {
                        BlockPos loc = pos.func_177972_a(dir);
                        if (!configurables.contains((Object)loc)) {
                            IoConfigRenderer.this.neighbours.add((Object)loc);
                        }
                    }
                });
            }
        });
        this.world = this.mc.field_71439_g.field_70170_p;
    }

    public void init() {
        this.initTime = System.currentTimeMillis();
    }

    public SelectedFace<E> getSelection() {
        return this.selection;
    }

    public void handleMouseInput() {
        Vector3d end;
        Vector3d start;
        int y;
        if (Mouse.getEventButton() == 0) {
            this.dragging = Mouse.getEventButtonState();
        }
        if (this.dragging) {
            double dx = (double)Mouse.getEventDX() / (double)this.mc.field_71443_c;
            double dy = (double)Mouse.getEventDY() / (double)this.mc.field_71440_d;
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)42)) {
                this.distance -= dy * 15.0;
            } else {
                this.yaw = (float)((double)this.yaw - 4.0 * dx * 180.0);
                this.pitch = (float)((double)this.pitch + 2.0 * dy * 180.0);
                this.pitch = (float)VecmathUtil.clamp((double)this.pitch, (double)-80.0, (double)80.0);
            }
        }
        this.distance -= (double)Mouse.getEventDWheel() * 0.01;
        this.distance = VecmathUtil.clamp((double)this.distance, (double)0.01, (double)200.0);
        long elapsed = System.currentTimeMillis() - this.initTime;
        int x = Mouse.getEventX();
        if (this.camera.getRayForPixel(x, y = Mouse.getEventY(), start = new Vector3d(), end = new Vector3d())) {
            end.scale(this.distance * 2.0);
            end.add(start);
            this.updateSelection(start, end);
        }
        if (!Mouse.getEventButtonState() && this.camera.isValid() && elapsed > 500L) {
            if (Mouse.getEventButton() == 1) {
                if (this.selection != null) {
                    ((IIoConfigurable)this.selection.config).toggleIoModeForFace(this.selection.face);
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketIoMode(this.selection.config, this.selection.face));
                }
            } else if (Mouse.getEventButton() == 0 && this.inNeigButBounds) {
                this.renderNeighbours = !this.renderNeighbours;
            }
        }
    }

    private void updateSelection(final @Nonnull Vector3d start, final @Nonnull Vector3d end) {
        TileEntity te;
        start.add(this.origin);
        end.add(this.origin);
        final ArrayList<RayTraceResult> hits = new ArrayList<RayTraceResult>();
        this.configurables.apply((NNList.Callback)new NNList.Callback<BlockPos>(){

            public void apply(@Nonnull BlockPos pos) {
                IBlockState bs;
                RayTraceResult hit;
                if (!IoConfigRenderer.this.world.func_175623_d(pos) && NullHelper.untrust((Object)(hit = (bs = IoConfigRenderer.this.world.func_180495_p(pos)).func_185910_a(IoConfigRenderer.this.world, pos, new Vec3d(start.x, start.y, start.z), new Vec3d(end.x, end.y, end.z)))) != null && hit.field_72313_a != RayTraceResult.Type.MISS) {
                    hits.add(hit);
                }
            }
        });
        this.selection = null;
        RayTraceResult hit = IoConfigRenderer.getClosestHit(new Vec3d(start.x, start.y, start.z), hits);
        if (hit != null && (te = this.world.func_175625_s(hit.func_178782_a())) instanceof IIoConfigurable) {
            EnumFacing face = hit.field_178784_b;
            this.selection = new SelectedFace<TileEntity>(te, face);
        }
    }

    public static RayTraceResult getClosestHit(@Nonnull Vec3d origin, @Nonnull Collection<RayTraceResult> candidates) {
        double minLengthSquared = Double.POSITIVE_INFINITY;
        RayTraceResult closest = null;
        for (RayTraceResult hit : candidates) {
            double lengthSquared;
            if (hit == null || !((lengthSquared = hit.field_72307_f.func_72436_e(origin)) < minLengthSquared)) continue;
            minLengthSquared = lengthSquared;
            closest = hit;
        }
        return closest;
    }

    public void drawScreen(int par1, int par2, float partialTick, @Nonnull Rectangle vp, @Nonnull Rectangle parentBounds) {
        if (!this.updateCamera(partialTick, vp.x, vp.y, vp.width, vp.height)) {
            return;
        }
        this.applyCamera(partialTick);
        TravelController.setSelectionEnabled(false);
        this.renderScene();
        TravelController.setSelectionEnabled(true);
        this.renderSelection();
        this.renderOverlay(par1, par2);
    }

    private void renderSelection() {
        if (this.selection == null) {
            return;
        }
        BoundingBox bb = new BoundingBox(((IIoConfigurable)this.selection.config).getLocation());
        TextureAtlasSprite icon = selectedFaceIcon.get(TextureAtlasSprite.class);
        NNList corners = bb.getCornersWithUvForFace(this.selection.face, icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h());
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        RenderUtil.bindBlockTexture();
        BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Vector3d trans = new Vector3d(-this.origin.x + this.eye.x, -this.origin.y + this.eye.y, -this.origin.z + this.eye.z);
        tes.func_178969_c(trans.x, trans.y, trans.z);
        RenderUtil.addVerticesToTessellator((List)corners, (VertexFormat)DefaultVertexFormats.field_181707_g, (boolean)true);
        Tessellator.func_178181_a().func_78381_a();
        tes.func_178969_c(0.0, 0.0, 0.0);
    }

    private void renderOverlay(int mx, int my) {
        Rectangle vp = this.camera.getViewport();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        int vpx = vp.x / scaledresolution.func_78325_e();
        int vph = vp.height / scaledresolution.func_78325_e();
        int vpw = vp.width / scaledresolution.func_78325_e();
        int vpy = (int)((float)(vp.y + vp.height - 4) / (float)scaledresolution.func_78325_e());
        GL11.glViewport((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)vpx, (float)vpy, (float)-2000.0f);
        GlStateManager.func_179140_f();
        int x = vpw - 17;
        int y = vph - 18;
        if ((mx -= vpx) >= x && mx <= x + IconEIO.IO_WHATSIT.width && (my -= vpy) >= y && my <= y + IconEIO.IO_WHATSIT.height) {
            GlStateManager.func_179147_l();
            RenderUtil.renderQuad2D((double)x, (double)y, (double)0.0, (double)IconEIO.IO_WHATSIT.width, (double)IconEIO.IO_WHATSIT.height, (Vector4f)new Vector4f(0.4f, 0.4f, 0.4f, 0.6f));
            GlStateManager.func_179084_k();
            this.inNeigButBounds = true;
        } else {
            this.inNeigButBounds = false;
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        IconEIO.map.render((IWidgetIcon)IconEIO.IO_WHATSIT, (double)x, (double)y, true);
        if (this.selection != null) {
            IconEIO ioIcon = null;
            int yOffset = 0;
            IoMode mode = ((IIoConfigurable)this.selection.config).getIoMode(this.selection.face);
            if (mode == IoMode.PULL) {
                ioIcon = IconEIO.INPUT;
            } else if (mode == IoMode.PUSH) {
                ioIcon = IconEIO.OUTPUT;
            } else if (mode == IoMode.PUSH_PULL) {
                ioIcon = IconEIO.INPUT_OUTPUT;
            } else if (mode == IoMode.DISABLED) {
                ioIcon = IconEIO.DISABLED;
                yOffset = 5;
            }
            y = vph - this.mc.field_71466_p.field_78288_b - 2;
            this.mc.field_71466_p.func_78276_b(this.getLabelForMode(mode), 4, y, ColorUtil.getRGB((Color)Color.white));
            if (ioIcon != null) {
                int w = this.mc.field_71466_p.func_78256_a(mode.getLocalisedName());
                double xd = (w - ioIcon.width) / 2;
                xd = Math.max(0, w);
                xd /= 2.0;
                xd += 4.0;
                ioIcon.getMap().render((IWidgetIcon)ioIcon, xd /= (double)scaledresolution.func_78325_e(), (double)(y - this.mc.field_71466_p.field_78288_b - 2 - yOffset), true);
            }
        }
    }

    @Nonnull
    protected String getLabelForMode(@Nonnull IoMode mode) {
        return mode.getLocalisedName();
    }

    private void renderScene() {
        GlStateManager.func_179089_o();
        GlStateManager.func_179091_B();
        RenderHelper.func_74518_a();
        this.mc.field_71460_t.func_175072_h();
        RenderUtil.bindBlockTexture();
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        final Vector3d trans = new Vector3d(-this.origin.x + this.eye.x, -this.origin.y + this.eye.y, -this.origin.z + this.eye.z);
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        try {
            NNList.of(BlockRenderLayer.class).apply((NNList.Callback)new NNList.Callback<BlockRenderLayer>(){

                public void apply(@Nonnull BlockRenderLayer layer) {
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                    IoConfigRenderer.this.setGlStateForPass(layer, false);
                    IoConfigRenderer.this.doWorldRenderPass(trans, (NNList<BlockPos>)IoConfigRenderer.this.configurables, layer);
                }
            });
            if (this.renderNeighbours) {
                NNList.of(BlockRenderLayer.class).apply((NNList.Callback)new NNList.Callback<BlockRenderLayer>(){

                    public void apply(@Nonnull BlockRenderLayer layer) {
                        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                        IoConfigRenderer.this.setGlStateForPass(layer, true);
                        IoConfigRenderer.this.doWorldRenderPass(trans, (NNList<BlockPos>)IoConfigRenderer.this.neighbours, layer);
                    }
                });
            }
        }
        finally {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        TileEntityRendererDispatcher.field_147556_a.field_147560_j = this.origin.x - this.eye.x;
        TileEntityRendererDispatcher.field_147556_a.field_147561_k = this.origin.y - this.eye.y;
        TileEntityRendererDispatcher.field_147556_a.field_147558_l = this.origin.z - this.eye.z;
        TileEntityRendererDispatcher.field_147554_b = this.origin.x - this.eye.x;
        TileEntityRendererDispatcher.field_147555_c = this.origin.y - this.eye.y;
        TileEntityRendererDispatcher.field_147552_d = this.origin.z - this.eye.z;
        for (int pass = 0; pass < 2; ++pass) {
            ForgeHooksClient.setRenderPass((int)pass);
            this.setGlStateForPass(pass, false);
            this.doTileEntityRenderPass(this.configurables, pass);
            if (!this.renderNeighbours) continue;
            this.setGlStateForPass(pass, true);
            this.doTileEntityRenderPass(this.neighbours, pass);
        }
        ForgeHooksClient.setRenderPass((int)-1);
        this.setGlStateForPass(0, false);
    }

    private void doTileEntityRenderPass(@Nonnull NNList<BlockPos> blocks, final int pass) {
        blocks.apply((NNList.Callback)new NNList.Callback<BlockPos>(){

            public void apply(@Nonnull BlockPos pos) {
                TileEntity tile = IoConfigRenderer.this.world.func_175625_s(pos);
                if (tile != null && tile.shouldRenderInPass(pass)) {
                    Vector3d at = new Vector3d(((IoConfigRenderer)IoConfigRenderer.this).eye.x, ((IoConfigRenderer)IoConfigRenderer.this).eye.y, ((IoConfigRenderer)IoConfigRenderer.this).eye.z);
                    at.x += (double)pos.func_177958_n() - ((IoConfigRenderer)IoConfigRenderer.this).origin.x;
                    at.y += (double)pos.func_177956_o() - ((IoConfigRenderer)IoConfigRenderer.this).origin.y;
                    at.z += (double)pos.func_177952_p() - ((IoConfigRenderer)IoConfigRenderer.this).origin.z;
                    if (tile.getClass() == TileEntityChest.class) {
                        TileEntityChest chest = (TileEntityChest)tile;
                        if (NullHelper.untrust((Object)chest.field_145991_k) != null) {
                            tile = chest.field_145991_k;
                            at.x -= 1.0;
                        } else if (NullHelper.untrust((Object)chest.field_145992_i) != null) {
                            tile = chest.field_145992_i;
                            at.z -= 1.0;
                        }
                    }
                    TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, at.x, at.y, at.z, 0.0f);
                }
            }
        });
    }

    private void doWorldRenderPass(@Nonnull Vector3d trans, @Nonnull NNList<BlockPos> blocks, final @Nonnull BlockRenderLayer layer) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Tessellator.func_178181_a().func_178180_c().func_178969_c(trans.x, trans.y, trans.z);
        blocks.apply((NNList.Callback)new NNList.Callback<BlockPos>(){

            public void apply(@Nonnull BlockPos pos) {
                IBlockState bs = IoConfigRenderer.this.world.func_180495_p(pos);
                Block block = bs.func_177230_c();
                if (block.canRenderInLayer(bs = bs.func_185899_b((IBlockAccess)IoConfigRenderer.this.world, pos), layer)) {
                    IoConfigRenderer.this.renderBlock(bs, pos, (IBlockAccess)IoConfigRenderer.this.world, Tessellator.func_178181_a().func_178180_c());
                }
            }
        });
        Tessellator.func_178181_a().func_78381_a();
        Tessellator.func_178181_a().func_178180_c().func_178969_c(0.0, 0.0, 0.0);
    }

    public void renderBlock(@Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull IBlockAccess blockAccess, @Nonnull BufferBuilder worldRendererIn) {
        try {
            BlockRendererDispatcher blockrendererdispatcher = this.mc.func_175602_ab();
            EnumBlockRenderType type = state.func_185901_i();
            if (type != EnumBlockRenderType.MODEL) {
                blockrendererdispatcher.func_175018_a(state, pos, blockAccess, worldRendererIn);
                return;
            }
            IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(state);
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)this.world, pos);
            blockrendererdispatcher.func_175019_b().func_178267_a(blockAccess, ibakedmodel, state, pos, worldRendererIn, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setGlStateForPass(@Nonnull BlockRenderLayer layer, boolean isNeighbour) {
        int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
        this.setGlStateForPass(pass, isNeighbour);
    }

    private void setGlStateForPass(int layer, boolean isNeighbour) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (isNeighbour) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            float alpha = 1.0f;
            float col = 1.0f;
            GlStateManager.func_179112_b((int)770, (int)32769);
            GL14.glBlendColor((float)col, (float)col, (float)col, (float)alpha);
            return;
        }
        if (layer == 0) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179132_a((boolean)false);
        }
    }

    private boolean updateCamera(float partialTick, int vpx, int vpy, int vpw, int vph) {
        if (vpw <= 0 || vph <= 0) {
            return false;
        }
        this.camera.setViewport(vpx, vpy, vpw, vph);
        this.camera.setProjectionMatrixAsPerspective(30.0, 0.05, 50.0, vpw, vph);
        this.eye.set(0.0, 0.0, this.distance);
        this.pitchRot.makeRotationX(Math.toRadians(this.pitch));
        this.yawRot.makeRotationY(Math.toRadians(this.yaw));
        this.pitchRot.transform(this.eye);
        this.yawRot.transform(this.eye);
        this.camera.setViewMatrixAsLookAt(this.eye, RenderUtil.ZERO_V, RenderUtil.UP_V);
        return this.camera.isValid();
    }

    private void applyCamera(float partialTick) {
        Rectangle vp = this.camera.getViewport();
        GL11.glViewport((int)vp.x, (int)vp.y, (int)vp.width, (int)vp.height);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        Matrix4d camaraViewMatrix = this.camera.getTransposeProjectionMatrix();
        if (camaraViewMatrix != null) {
            RenderUtil.loadMatrix((Matrix4d)camaraViewMatrix);
        }
        GL11.glMatrixMode((int)5888);
        Matrix4d cameraViewMatrix = this.camera.getTransposeViewMatrix();
        if (cameraViewMatrix != null) {
            RenderUtil.loadMatrix((Matrix4d)cameraViewMatrix);
        }
        GL11.glTranslatef((float)(-((float)this.eye.x)), (float)(-((float)this.eye.y)), (float)(-((float)this.eye.z)));
    }

    public static class SelectedFace<E extends TileEntity> {
        @Nonnull
        public final E config;
        @Nonnull
        public final EnumFacing face;

        public SelectedFace(@Nonnull E config, @Nonnull EnumFacing face) {
            this.config = config;
            this.face = face;
        }

        public String toString() {
            return "SelectedFace [config=" + this.config + ", face=" + this.face + "]";
        }
    }
}

