/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.harvesters;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.base.farming.harvesters.IHarvestingTarget;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TreeHarvester
implements NNList.Callback<BlockPos> {
    @Nonnull
    private final NNList<BlockPos> candidates = new NNList();
    @Nonnull
    private final Set<BlockPos> seen = new HashSet<BlockPos>();
    @Nonnull
    private final World world;
    @Nonnull
    private final NNList<BlockPos> result;
    @Nonnull
    private final IHarvestingTarget target;
    @Nonnull
    private BlockPos next;

    public static void harvest(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull HarvestResult res, @Nonnull IHarvestingTarget target) {
        TreeHarvester visitor = new TreeHarvester(world, pos, res.getHarvestedBlocks(), target);
        while (visitor.hasNext()) {
            NNList.SHELL.apply((NNList.Callback)visitor);
        }
    }

    private TreeHarvester(@Nonnull World world, @Nonnull BlockPos start, @Nonnull NNList<BlockPos> result, @Nonnull IHarvestingTarget target) {
        this.world = world;
        this.result = result;
        this.next = start;
        this.target = target;
        this.candidates.add((Object)start);
        this.seen.add(start);
        result.add((Object)start);
    }

    boolean hasNext() {
        if (this.candidates.isEmpty()) {
            return false;
        }
        this.next = (BlockPos)this.candidates.remove(0);
        return true;
    }

    public void apply(@Nonnull BlockPos offset) {
        BlockPos neighbor = this.next.func_177971_a((Vec3i)offset);
        if (!this.seen.contains(neighbor) && this.target.isInBounds(neighbor)) {
            IBlockState blockState;
            this.seen.add(neighbor);
            if (this.world.func_175667_e(neighbor) && this.target.isTarget(blockState = this.world.func_180495_p(neighbor))) {
                this.result.add((Object)neighbor);
                this.candidates.add((Object)neighbor);
            }
        }
    }
}

